/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import org.fabric3.binding.jms.generator.JmsGeneratorHelper;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.DeliveryMode;
import org.fabric3.binding.jms.spi.common.DestinationType;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsConnectionSourceDefinition;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTargetDefinition;
import org.fabric3.spi.channel.ChannelIntents;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JmsConnectionBindingGenerator
implements ConnectionBindingGenerator<JmsBindingDefinition> {
    private JmsResourceProvisioner provisioner;

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public PhysicalConnectionSourceDefinition generateConnectionSource(LogicalConsumer consumer, LogicalBinding<JmsBindingDefinition> binding) throws GenerationException {
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        URI uri = consumer.getUri();
        String specifier = JmsGeneratorHelper.getSourceSpecifier(uri);
        metadata.setClientIdSpecifier(specifier);
        ConnectionFactoryDefinition factory = metadata.getConnectionFactory();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(factory, specifier, TransactionType.NONE);
        this.generateIntents(binding, metadata);
        metadata.getDestination().setType(DestinationType.TOPIC);
        JmsConnectionSourceDefinition definition = new JmsConnectionSourceDefinition(uri, metadata);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionSource(definition);
        }
        return definition;
    }

    public PhysicalConnectionTargetDefinition generateConnectionTarget(LogicalProducer producer, LogicalBinding<JmsBindingDefinition> binding) throws GenerationException {
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        String specifier = JmsGeneratorHelper.getTargetSpecifier(producer.getUri());
        ConnectionFactoryDefinition factory = metadata.getConnectionFactory();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(factory, specifier, TransactionType.NONE);
        this.generateIntents(binding, metadata);
        JmsConnectionTargetDefinition definition = new JmsConnectionTargetDefinition(uri, metadata);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionTarget(definition);
        }
        return definition;
    }

    public PhysicalChannelBindingDefinition generateChannelBinding(LogicalBinding<JmsBindingDefinition> binding) throws GenerationException {
        return null;
    }

    private void generateIntents(LogicalBinding<JmsBindingDefinition> binding, JmsBindingMetadata metadata) {
        LogicalChannel parent = (LogicalChannel)binding.getParent();
        if (((JmsBindingDefinition)binding.getDefinition()).getIntents().contains(ChannelIntents.DURABLE_INTENT) || parent.getDefinition().getIntents().contains(ChannelIntents.DURABLE_INTENT)) {
            metadata.setDurable(true);
        }
        if (((JmsBindingDefinition)binding.getDefinition()).getIntents().contains(ChannelIntents.NON_PERSISTENT_INTENT) || parent.getDefinition().getIntents().contains(ChannelIntents.NON_PERSISTENT_INTENT)) {
            metadata.getHeaders().setDeliveryMode(DeliveryMode.NON_PERSISTENT);
        }
    }
}

