/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.type.binding.BindingHandlerDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsGeneratorHelper {
    public static String getSourceSpecifier(URI uri) {
        return JmsGeneratorHelper.getSpecifier(uri) + "Source";
    }

    public static String getTargetSpecifier(URI uri) {
        return JmsGeneratorHelper.getSpecifier(uri) + "Target";
    }

    public static void generateDefaultFactoryConfiguration(ConnectionFactoryDefinition factory, String specifier, TransactionType trxType) {
        if (factory.getName() == null && factory.getTemplateName() == null) {
            factory.setName(specifier);
            if (TransactionType.GLOBAL == trxType) {
                factory.setTemplateName("xaDefault");
            } else {
                factory.setTemplateName("default");
            }
        } else if (factory.getTemplateName() != null) {
            factory.setName(specifier);
        }
    }

    public static List<PhysicalBindingHandlerDefinition> generateBindingHandlers(URI domainUri, JmsBindingDefinition definition) {
        ArrayList<PhysicalBindingHandlerDefinition> handlers = new ArrayList<PhysicalBindingHandlerDefinition>();
        for (BindingHandlerDefinition handlerDefinition : definition.getHandlers()) {
            URI resolvedUri = URI.create(domainUri.toString() + "/" + handlerDefinition.getTarget());
            handlers.add(new PhysicalBindingHandlerDefinition(resolvedUri));
        }
        return handlers;
    }

    private static String getSpecifier(URI uri) {
        String specifier = uri.getPath().substring(1).replace("/", ".");
        String fragment = uri.getFragment();
        if (fragment != null) {
            specifier = specifier + "." + fragment;
        }
        return specifier;
    }

    private JmsGeneratorHelper() {
    }
}

