/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.loader;

import java.net.URI;
import java.util.HashSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.jms.loader.InvalidJmsBinding;
import org.fabric3.binding.jms.loader.JmsLoaderHelper;
import org.fabric3.binding.jms.loader.JmsUriException;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.binding.jms.spi.common.ActivationSpec;
import org.fabric3.binding.jms.spi.common.CacheLevel;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CorrelationScheme;
import org.fabric3.binding.jms.spi.common.CreateOption;
import org.fabric3.binding.jms.spi.common.DeliveryMode;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.DestinationType;
import org.fabric3.binding.jms.spi.common.HeadersDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.MessageSelection;
import org.fabric3.binding.jms.spi.common.OperationPropertiesDefinition;
import org.fabric3.binding.jms.spi.common.PropertyAwareObject;
import org.fabric3.binding.jms.spi.common.ResponseDefinition;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.fabric3.spi.model.type.binding.BindingHandlerDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JmsBindingLoader
extends AbstractValidatingTypeLoader<JmsBindingDefinition> {
    private LoaderRegistry registry;
    private LoaderHelper loaderHelper;
    private int defaultResponseTimeout = 600000;
    private int defaultTransactionTimeout = 30;
    private int defaultReceiveTimeout = this.defaultTransactionTimeout / 2 * 1000;

    @Property(required=false)
    public void setDefaultResponseTimeout(int defaultResponseTimeout) {
        this.defaultResponseTimeout = defaultResponseTimeout;
    }

    @Property(required=false)
    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.defaultTransactionTimeout = defaultTransactionTimeout;
        this.defaultReceiveTimeout = defaultTransactionTimeout / 2 * 1000;
    }

    public JmsBindingLoader(@Reference LoaderHelper loaderHelper, @Reference LoaderRegistry registry) {
        this.loaderHelper = loaderHelper;
        this.registry = registry;
        this.addAttributes(new String[]{"uri", "activationSpec", "wireFormat", "jndiURL", "initialContextFactory", "requires", "messageSelection", "policySets", "create", "type", "destination", "connectionFactory", "messageSelection", "connectionFactory.template", "type", "timeToLive", "resourceAdapter", "priority", "deliveryMode", "correlationScheme", "name", "cache", "idle.limit", "receive.timeout", "response.timeout", "max.messages", "recovery.interval", "max.receivers", "min.receivers"});
    }

    public JmsBindingDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        JmsBindingMetadata metadata;
        this.validateAttributes(reader, context);
        String bindingName = reader.getAttributeValue(null, "name");
        String uri = reader.getAttributeValue(null, "uri");
        if (uri != null) {
            try {
                metadata = JmsLoaderHelper.parseUri(uri);
            }
            catch (JmsUriException e) {
                InvalidValue failure = new InvalidValue("Invalid JMS binding URI: " + uri, reader, (Throwable)((Object)e));
                context.addError((ValidationFailure)failure);
                return null;
            }
        } else {
            metadata = new JmsBindingMetadata();
        }
        JmsBindingDefinition definition = new JmsBindingDefinition(bindingName, metadata);
        NamespaceContext namespace = reader.getNamespaceContext();
        String targetNamespace = context.getTargetNamespace();
        this.parseCorrelationScheme(metadata, namespace, targetNamespace, reader, context);
        metadata.setJndiUrl(reader.getAttributeValue(null, "jndiURL"));
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        this.loadFabric3Attributes(metadata, reader, context);
        block8: while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("handler".equals(name)) {
                        try {
                            BindingHandlerDefinition handler = (BindingHandlerDefinition)this.registry.load(reader, BindingHandlerDefinition.class, context);
                            definition.addHandler(handler);
                        }
                        catch (UnrecognizedElementException e) {
                            UnrecognizedElement failure = new UnrecognizedElement(reader);
                            context.addError((ValidationFailure)failure);
                        }
                        continue block8;
                    }
                    if ("destination".equals(name)) {
                        if (uri != null) {
                            InvalidJmsBinding error = new InvalidJmsBinding("A destination cannot be defined in a JMS uri and as part of the binding.jms element", reader);
                            context.addError((ValidationFailure)error);
                        }
                        DestinationDefinition destination = this.loadDestination(reader, context);
                        metadata.setDestination(destination);
                        break;
                    }
                    if ("connectionFactory".equals(name)) {
                        ConnectionFactoryDefinition connectionFactory = this.loadConnectionFactory(reader, context);
                        metadata.setConnectionFactory(connectionFactory);
                        break;
                    }
                    if ("activationSpec".equals(name)) {
                        ActivationSpec spec = this.loadActivationSpec(reader, context);
                        metadata.setActivationSpec(spec);
                        break;
                    }
                    if ("response".equals(name)) {
                        ResponseDefinition response = this.loadResponse(reader, context);
                        metadata.setResponse(response);
                        break;
                    }
                    if ("headers".equals(name)) {
                        HeadersDefinition headers = metadata.getHeaders();
                        this.loadHeaders(headers, reader, context);
                        break;
                    }
                    if ("messageSelection".equals(name)) {
                        MessageSelection messageSelection = this.loadMessageSelection(reader, context);
                        metadata.setMessageSelection(messageSelection);
                        break;
                    }
                    if (!"operationProperties".equals(name)) break;
                    OperationPropertiesDefinition operationProperties = this.loadOperationProperties(reader, context);
                    metadata.addOperationProperties(operationProperties.getName(), operationProperties);
                    break;
                }
                case 2: {
                    String target;
                    String name = reader.getName().getLocalPart();
                    if (!"binding.jms".equals(name)) break;
                    DestinationDefinition destinationDefinition = metadata.getDestination();
                    if (destinationDefinition != null) {
                        target = destinationDefinition.getName();
                        URI bindingUri = URI.create("jms://" + target);
                        definition.setGeneratedTargetUri(bindingUri);
                    } else if (metadata.getActivationSpec() != null) {
                        target = metadata.getActivationSpec().getName();
                        URI bindingUri = URI.create("jms://" + target);
                        definition.setGeneratedTargetUri(bindingUri);
                    }
                    this.validate(definition, reader, context);
                    return definition;
                }
            }
        }
    }

    private void parseCorrelationScheme(JmsBindingMetadata metadata, NamespaceContext namespace, String targetNamespace, XMLStreamReader reader, IntrospectionContext context) {
        String correlationScheme = reader.getAttributeValue(null, "correlationScheme");
        if (correlationScheme != null) {
            QName scheme = LoaderUtil.getQName((String)correlationScheme, (String)targetNamespace, (NamespaceContext)namespace);
            if ("messageID".equalsIgnoreCase(scheme.getLocalPart())) {
                metadata.setCorrelationScheme(CorrelationScheme.MESSAGE_ID);
            } else if ("correlationID".equalsIgnoreCase(scheme.getLocalPart())) {
                metadata.setCorrelationScheme(CorrelationScheme.CORRELATION_ID);
            } else if ("none".equalsIgnoreCase(scheme.getLocalPart())) {
                metadata.setCorrelationScheme(CorrelationScheme.NONE);
            } else {
                InvalidValue error = new InvalidValue("Invalid value specified for correlationScheme attribute: " + scheme.getLocalPart(), reader);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private void loadFabric3Attributes(JmsBindingMetadata metadata, XMLStreamReader reader, IntrospectionContext context) {
        String min;
        String max;
        String recoveryInterval;
        String idleLimit;
        String cacheLevel = reader.getAttributeValue(null, "cache");
        if ("connection".equalsIgnoreCase(cacheLevel)) {
            metadata.setCacheLevel(CacheLevel.CONNECTION);
        } else if ("session".equalsIgnoreCase(cacheLevel)) {
            metadata.setCacheLevel(CacheLevel.ADMINISTERED_OBJECTS);
        } else if (cacheLevel != null) {
            InvalidValue error = new InvalidValue("Invalid cache level attribute", reader);
            context.addError((ValidationFailure)error);
        }
        String templateName = reader.getAttributeValue(null, "connectionFactory.template");
        if (templateName != null) {
            metadata.getConnectionFactory().setTemplateName(templateName);
        }
        if ((idleLimit = reader.getAttributeValue(null, "idle.limit")) != null) {
            try {
                int val = Integer.parseInt(idleLimit);
                metadata.setIdleLimit(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid idle.limit attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        String receiveTimeout = reader.getAttributeValue(null, "receive.timeout");
        int receiveVal = this.defaultReceiveTimeout;
        if (receiveTimeout != null) {
            try {
                receiveVal = Integer.parseInt(receiveTimeout);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid receive.timeout attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        metadata.setReceiveTimeout(receiveVal);
        String responseTimeout = reader.getAttributeValue(null, "response.timeout");
        int responseVal = this.defaultResponseTimeout;
        if (responseTimeout != null) {
            try {
                responseVal = Integer.parseInt(responseTimeout);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid response.timeout attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        metadata.setResponseTimeout(responseVal);
        String maxMessagesProcess = reader.getAttributeValue(null, "max.messages");
        if (maxMessagesProcess != null) {
            try {
                int val = Integer.parseInt(maxMessagesProcess);
                metadata.setMaxMessagesToProcess(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid max.messages attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((recoveryInterval = reader.getAttributeValue(null, "recovery.interval")) != null) {
            try {
                int val = Integer.parseInt(recoveryInterval);
                metadata.setRecoveryInterval(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid recovery.interval attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((max = reader.getAttributeValue(null, "max.receivers")) != null) {
            try {
                int val = Integer.parseInt(max);
                metadata.setMaxReceivers(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid max.receivers attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
        if ((min = reader.getAttributeValue(null, "min.receivers")) != null) {
            try {
                int val = Integer.parseInt(min);
                metadata.setMinReceivers(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid min.receivers attribute", reader, (Throwable)e);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private ActivationSpec loadActivationSpec(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String jndiName = reader.getAttributeValue(null, "jndiName");
        CreateOption create = this.parseCreate(reader, context);
        ActivationSpec spec = new ActivationSpec(jndiName, create);
        this.loadProperties(reader, spec, "activationSpec");
        return spec;
    }

    private ResponseDefinition loadResponse(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ResponseDefinition response = new ResponseDefinition();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("destination".equals(name)) {
                        DestinationDefinition destination = this.loadDestination(reader, context);
                        response.setDestination(destination);
                        break;
                    }
                    if ("activationSpec".equals(name)) {
                        ActivationSpec spec = this.loadActivationSpec(reader, context);
                        response.setActivationSpec(spec);
                        break;
                    }
                    if (!"connectionFactory".equals(name)) break;
                    ConnectionFactoryDefinition connectionFactory = this.loadConnectionFactory(reader, context);
                    response.setConnectionFactory(connectionFactory);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"response".equals(name)) break;
                    return response;
                }
            }
        }
    }

    private ConnectionFactoryDefinition loadConnectionFactory(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ConnectionFactoryDefinition connectionFactory = new ConnectionFactoryDefinition();
        connectionFactory.setName(reader.getAttributeValue(null, "jndiName"));
        CreateOption create = this.parseCreate(reader, context);
        connectionFactory.setCreate(create);
        this.loadProperties(reader, connectionFactory, "connectionFactory");
        return connectionFactory;
    }

    private DestinationDefinition loadDestination(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        DestinationDefinition destination = new DestinationDefinition();
        String jndiName = reader.getAttributeValue(null, "jndiName");
        if (jndiName != null) {
            destination.setName(jndiName);
        } else {
            String name = reader.getAttributeValue(null, "name");
            if (name == null) {
                MissingAttribute error = new MissingAttribute("Destination must have either a jndiName or name attribute set", reader);
                context.addError((ValidationFailure)error);
            }
        }
        CreateOption create = this.parseCreate(reader, context);
        destination.setCreate(create);
        String type = reader.getAttributeValue(null, "type");
        if (type != null) {
            if ("queue".equalsIgnoreCase(type)) {
                destination.setType(DestinationType.QUEUE);
            } else if ("topic".equalsIgnoreCase(type)) {
                destination.setType(DestinationType.TOPIC);
            } else {
                InvalidValue error = new InvalidValue("Invalid value specified for destination type: " + type, reader);
                context.addError((ValidationFailure)error);
            }
        }
        this.loadProperties(reader, destination, "destination");
        return destination;
    }

    private CreateOption parseCreate(XMLStreamReader reader, IntrospectionContext context) {
        String create = reader.getAttributeValue(null, "create");
        if (create != null) {
            if ("always".equals(create)) {
                return CreateOption.ALWAYS;
            }
            if ("never".equalsIgnoreCase(create)) {
                return CreateOption.NEVER;
            }
            if ("ifNotExist".equalsIgnoreCase(create)) {
                return CreateOption.IF_NOT_EXIST;
            }
            InvalidValue error = new InvalidValue("Invalid value specified for create attribute: " + create, reader);
            context.addError((ValidationFailure)error);
        }
        return CreateOption.IF_NOT_EXIST;
    }

    private void loadHeaders(HeadersDefinition headers, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String timeToLive;
        String priority;
        String deliveryMode = reader.getAttributeValue(null, "deliveryMode");
        if (deliveryMode != null) {
            if ("PERSISTENT".equalsIgnoreCase(deliveryMode)) {
                headers.setDeliveryMode(DeliveryMode.PERSISTENT);
            } else if ("NONPERSISTENT".equalsIgnoreCase(deliveryMode)) {
                headers.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
            } else {
                InvalidValue failure = new InvalidValue("Invalid delivery mode: " + deliveryMode, reader);
                context.addError((ValidationFailure)failure);
            }
        }
        if ((priority = reader.getAttributeValue(null, "priority")) != null) {
            InvalidValue failure;
            try {
                Integer value = Integer.valueOf(priority);
                headers.setPriority(value);
                if (value < 0 || value > 9) {
                    failure = new InvalidValue("Invalid priority: " + priority + ". Values must be from 0-9.", reader);
                    context.addError((ValidationFailure)failure);
                }
            }
            catch (NumberFormatException nfe) {
                failure = new InvalidValue("Invalid priority: " + priority, reader, (Throwable)nfe);
                context.addError((ValidationFailure)failure);
            }
        }
        if ((timeToLive = reader.getAttributeValue(null, "timeToLive")) != null) {
            try {
                headers.setTimeToLive(Long.valueOf(timeToLive));
            }
            catch (NumberFormatException nfe) {
                InvalidValue failure = new InvalidValue("Invalid time-to-live value: " + timeToLive, reader, (Throwable)nfe);
                context.addError((ValidationFailure)failure);
            }
        }
        headers.setJmsType(reader.getAttributeValue(null, "type"));
        this.loadProperties(reader, headers, "headers");
    }

    private MessageSelection loadMessageSelection(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String selector = reader.getAttributeValue(null, "selector");
        if (selector == null) {
            MissingAttribute error = new MissingAttribute("Selector not specified for message selection", reader);
            context.addError((ValidationFailure)error);
            selector = "invalid";
        }
        MessageSelection messageSelection = new MessageSelection(selector);
        this.loadProperties(reader, messageSelection, "messageSelection");
        return messageSelection;
    }

    private OperationPropertiesDefinition loadOperationProperties(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        OperationPropertiesDefinition operationProperties = new OperationPropertiesDefinition();
        operationProperties.setName(reader.getAttributeValue(null, "name"));
        operationProperties.setSelectedOperation(reader.getAttributeValue(null, "selectedOperation"));
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("headers".equals(name)) {
                        HeadersDefinition headers = operationProperties.getHeaders();
                        this.loadHeaders(headers, reader, context);
                        break;
                    }
                    if (!"property".equals(name)) break;
                    this.loadProperty(reader, operationProperties);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"operationProperties".equals(name)) break;
                    return operationProperties;
                }
            }
        }
    }

    private void loadProperties(XMLStreamReader reader, PropertyAwareObject parent, String parentName) throws XMLStreamException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if (!"property".equals(name)) break;
                    this.loadProperty(reader, parent);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!parentName.equals(name)) break;
                    return;
                }
            }
        }
    }

    private void loadProperty(XMLStreamReader reader, PropertyAwareObject parent) throws XMLStreamException {
        String key = reader.getAttributeValue(null, "name");
        String value = reader.getElementText();
        parent.addProperty(key, value);
    }

    private void validate(JmsBindingDefinition definition, XMLStreamReader reader, IntrospectionContext context) {
        ResponseDefinition response;
        InvalidJmsBinding error;
        JmsBindingMetadata metadata = definition.getJmsMetadata();
        if (metadata.getConnectionFactory().isConfigured() && metadata.getDestination() == null) {
            error = new InvalidJmsBinding("A destination must be specified", reader);
            context.addError((ValidationFailure)error);
        }
        if (metadata.getActivationSpec() != null && metadata.getConnectionFactory().isConfigured()) {
            error = new InvalidJmsBinding("Activation spec and connection factory cannot both be specified on a JMS binding", reader);
            context.addError((ValidationFailure)error);
        }
        DestinationDefinition requestDestination = metadata.getDestination();
        ActivationSpec requestSpec = metadata.getActivationSpec();
        if (requestDestination != null && requestSpec != null && requestDestination.getName() != null && !requestDestination.getName().equals(requestSpec.getName())) {
            InvalidJmsBinding error2 = new InvalidJmsBinding("Activation spec and destination configuration must refer to the same destination", reader);
            context.addError((ValidationFailure)error2);
        }
        if ((response = metadata.getResponse()) != null) {
            DestinationDefinition responseDestination;
            ActivationSpec responseSpec = response.getActivationSpec();
            if (responseSpec != null && response.getConnectionFactory().isConfigured()) {
                InvalidJmsBinding error3 = new InvalidJmsBinding("Activation spec and connection factory cannot both be specified on a JMS binding", reader);
                context.addError((ValidationFailure)error3);
            }
            if ((responseDestination = response.getDestination()) != null && responseSpec != null && responseDestination.getName() != null && !responseDestination.getName().equals(responseSpec.getName())) {
                InvalidJmsBinding error4 = new InvalidJmsBinding("Activation spec and destination configuration must refer to the same destination", reader);
                context.addError((ValidationFailure)error4);
            }
        }
        HashSet<String> seen = new HashSet<String>();
        for (OperationPropertiesDefinition entry : metadata.getOperationProperties().values()) {
            String name = entry.getSelectedOperation();
            if (seen.contains(name)) {
                InvalidJmsBinding error5 = new InvalidJmsBinding("Duplicate selected operation for property defined: " + name, reader);
                context.addError((ValidationFailure)error5);
                continue;
            }
            seen.add(name);
        }
    }
}

