/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.loader;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.fabric3.binding.jms.loader.JmsUriException;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CreateOption;
import org.fabric3.binding.jms.spi.common.DeliveryMode;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.DestinationType;
import org.fabric3.binding.jms.spi.common.HeadersDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.JmsUri;
import org.fabric3.binding.jms.spi.common.MessageSelection;
import org.fabric3.binding.jms.spi.common.ResponseDefinition;

public class JmsLoaderHelper {
    public static final String CONNECTION_FACORY_NAME = "jndiConnectionFactoryName";
    public static final String DESTINATION_TYPE = "destinationType";
    public static final String DELIVERY_MODE = "deliveryMode";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String PRIORITY = "priority";
    public static final String RESPONSE_DESTINATION = "responseDestination";
    public static final String MESSAGE_SELECTOR = "selector";
    public static final String REPLY_TO_NAME = "replyToName";

    private JmsLoaderHelper() {
    }

    public static JmsBindingMetadata parseUri(String uri) throws JmsUriException {
        boolean matches = Pattern.matches("jms:(.*?)[\\?(.*?)=(.*?)((&(.*?)=(.*?))*)]?", uri);
        if (!matches) {
            throw new JmsUriException("Invalid JMS URI: " + uri);
        }
        JmsUri jmsUri = JmsLoaderHelper.doParse(uri);
        return JmsLoaderHelper.getJmsMetadataFromUri(jmsUri);
    }

    private static JmsUri doParse(String uri) {
        StringTokenizer token = new StringTokenizer(uri, ":?=&");
        String propertyName = null;
        int pos = 0;
        JmsUri result = null;
        while (token.hasMoreTokens()) {
            String current = token.nextToken();
            if (1 == pos) {
                result = new JmsUri(current);
            } else if (pos % 2 == 0) {
                propertyName = current;
            } else if (0 != pos) {
                assert (propertyName != null);
                assert (result != null);
                result.getProperties().put(propertyName.trim(), current.trim());
            }
            ++pos;
        }
        return result;
    }

    private static JmsBindingMetadata getJmsMetadataFromUri(JmsUri jmsUri) throws JmsUriException {
        String replyTo;
        String selector;
        String priority;
        String timeToLive;
        JmsBindingMetadata metadata = new JmsBindingMetadata();
        Map<String, String> uriProperties = jmsUri.getProperties();
        DestinationDefinition destination = new DestinationDefinition();
        String destinationType = uriProperties.get(DESTINATION_TYPE);
        if ("topic".equalsIgnoreCase(destinationType)) {
            destination.setType(DestinationType.TOPIC);
        }
        destination.setName(jmsUri.getDestination());
        destination.setCreate(CreateOption.NEVER);
        metadata.setDestination(destination);
        ConnectionFactoryDefinition connectionFactory = new ConnectionFactoryDefinition();
        String connectionFactoryName = uriProperties.get(CONNECTION_FACORY_NAME);
        connectionFactory.setName(connectionFactoryName);
        connectionFactory.setCreate(CreateOption.NEVER);
        metadata.setConnectionFactory(connectionFactory);
        ResponseDefinition response = new ResponseDefinition();
        response.setConnectionFactory(connectionFactory);
        DestinationDefinition responseDestinationDef = new DestinationDefinition();
        String responseDestination = uriProperties.get(RESPONSE_DESTINATION);
        responseDestinationDef.setName(responseDestination);
        responseDestinationDef.setCreate(CreateOption.NEVER);
        response.setDestination(responseDestinationDef);
        metadata.setResponse(response);
        HeadersDefinition headers = metadata.getUriHeaders();
        Map<String, String> properties = jmsUri.getProperties();
        String mode = properties.get(DELIVERY_MODE);
        if (mode != null) {
            if ("nonpersistent".equals(mode)) {
                headers.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
            } else if ("persistent".equals(mode)) {
                headers.setDeliveryMode(DeliveryMode.PERSISTENT);
            } else {
                throw new JmsUriException("Invalid delivery mode specified: " + mode);
            }
        }
        if ((timeToLive = properties.get(TIME_TO_LIVE)) != null) {
            try {
                long val = Long.parseLong(timeToLive);
                headers.setTimeToLive(val);
            }
            catch (NumberFormatException e) {
                throw new JmsUriException("Invalid time to live: " + timeToLive, e);
            }
        }
        if ((priority = properties.get(PRIORITY)) != null) {
            try {
                int val = Integer.parseInt(priority);
                if (val < 0 || val > 9) {
                    throw new JmsUriException("Priority must be between 0 and 9: " + timeToLive);
                }
                headers.setPriority(val);
            }
            catch (NumberFormatException e) {
                throw new JmsUriException("Invalid priority: " + priority, e);
            }
        }
        if ((selector = properties.get(MESSAGE_SELECTOR)) != null) {
            MessageSelection selection = new MessageSelection(selector);
            metadata.setUriMessageSelection(selection);
        }
        if ((replyTo = properties.get(REPLY_TO_NAME)) != null) {
            // empty if block
        }
        return metadata;
    }
}

