/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.net.URI;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.jms.runtime.EventStreamListener;
import org.fabric3.binding.jms.runtime.ListenerMonitor;
import org.fabric3.binding.jms.runtime.container.ContainerConfiguration;
import org.fabric3.binding.jms.runtime.container.MessageContainerManager;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.common.CacheLevel;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.provision.JmsConnectionSourceDefinition;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConnectionSourceAttacher
implements SourceConnectionAttacher<JmsConnectionSourceDefinition> {
    private AdministeredObjectResolver resolver;
    private ClassLoaderRegistry classLoaderRegistry;
    private MessageContainerManager containerManager;
    private ListenerMonitor monitor;
    private HostInfo info;

    public JmsConnectionSourceAttacher(@Reference AdministeredObjectResolver resolver, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference MessageContainerManager containerManager, @Reference HostInfo info, @Monitor ListenerMonitor monitor) {
        this.resolver = resolver;
        this.classLoaderRegistry = classLoaderRegistry;
        this.containerManager = containerManager;
        this.info = info;
        this.monitor = monitor;
    }

    public void attach(JmsConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        URI serviceUri = source.getUri();
        ClassLoader sourceClassLoader = this.classLoaderRegistry.getClassLoader(source.getClassLoaderId());
        JmsBindingMetadata metadata = source.getMetadata();
        String clientId = this.info.getDomain().getAuthority() + ":" + this.info.getRuntimeName() + ":" + metadata.getClientIdSpecifier();
        ResolvedObjects objects = this.resolveAdministeredObjects(source, clientId);
        ContainerConfiguration configuration = new ContainerConfiguration();
        try {
            ConnectionFactory connectionFactory = objects.getRequestFactory();
            Destination destination = objects.getRequestDestination();
            List streams = connection.getEventStreams();
            if (streams.size() != 1) {
                throw new ConnectionAttachException("There must be a single event stream: " + streams.size());
            }
            EventStream stream = (EventStream)streams.get(0);
            EventStreamListener listener = new EventStreamListener(sourceClassLoader, stream.getHeadHandler(), this.monitor);
            configuration.setClientId(clientId);
            configuration.setDestinationType(metadata.getDestination().geType());
            configuration.setDestination(destination);
            configuration.setFactory(connectionFactory);
            configuration.setMessageListener(listener);
            configuration.setUri(serviceUri);
            this.populateConfiguration(configuration, metadata);
            if (this.containerManager.isRegistered(serviceUri)) {
                this.containerManager.unregister(serviceUri);
            }
            this.containerManager.register(configuration);
        }
        catch (JMSException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
    }

    public void detach(JmsConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ConnectionAttachException {
        try {
            this.containerManager.unregister(source.getUri());
            this.resolver.release(source.getMetadata().getConnectionFactory());
        }
        catch (JMSException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
        catch (JmsResolutionException e) {
            throw new ConnectionAttachException((Throwable)((Object)e));
        }
    }

    private void populateConfiguration(ContainerConfiguration configuration, JmsBindingMetadata metadata) {
        CacheLevel cacheLevel = metadata.getCacheLevel();
        if (CacheLevel.CONNECTION == cacheLevel) {
            configuration.setCacheLevel(1);
        } else if (CacheLevel.ADMINISTERED_OBJECTS == cacheLevel) {
            configuration.setCacheLevel(2);
        } else {
            configuration.setCacheLevel(0);
        }
        configuration.setIdleLimit(metadata.getIdleLimit());
        configuration.setMaxMessagesToProcess(metadata.getMaxMessagesToProcess());
        configuration.setMaxReceivers(metadata.getMaxReceivers());
        configuration.setMinReceivers(metadata.getMinReceivers());
        configuration.setReceiveTimeout(metadata.getReceiveTimeout());
        configuration.setDurable(metadata.isDurable());
    }

    private ResolvedObjects resolveAdministeredObjects(JmsConnectionSourceDefinition source, String clientId) throws ConnectionAttachException {
        try {
            JmsBindingMetadata metadata = source.getMetadata();
            ConnectionFactoryDefinition definition = metadata.getConnectionFactory();
            ConnectionFactory requestConnectionFactory = this.resolver.resolve(definition);
            DestinationDefinition requestDestinationDefinition = metadata.getDestination();
            Destination requestDestination = metadata.isDurable() ? this.resolver.resolve(requestDestinationDefinition, clientId, requestConnectionFactory) : this.resolver.resolve(requestDestinationDefinition, requestConnectionFactory);
            return new ResolvedObjects(requestConnectionFactory, requestDestination);
        }
        catch (JmsResolutionException e) {
            throw new ConnectionAttachException((Throwable)((Object)e));
        }
    }

    private class ResolvedObjects {
        private ConnectionFactory requestFactory;
        private Destination requestDestination;

        private ResolvedObjects(ConnectionFactory requestFactory, Destination requestDestination) {
            this.requestFactory = requestFactory;
            this.requestDestination = requestDestination;
        }

        public ConnectionFactory getRequestFactory() {
            return this.requestFactory;
        }

        public Destination getRequestDestination() {
            return this.requestDestination;
        }
    }
}

