/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.fabric3.binding.jms.runtime.JmsEventStreamHandler;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.DeliveryMode;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.HeadersDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTargetDefinition;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConnectionTargetAttacher
implements TargetConnectionAttacher<JmsConnectionTargetDefinition> {
    private AdministeredObjectResolver resolver;

    public JmsConnectionTargetAttacher(@Reference AdministeredObjectResolver resolver) {
        this.resolver = resolver;
    }

    public void attach(PhysicalConnectionSourceDefinition source, JmsConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        Destination destination;
        ConnectionFactory connectionFactory;
        JmsBindingMetadata metadata = target.getMetadata();
        ConnectionFactoryDefinition connectionFactoryDefinition = metadata.getConnectionFactory();
        HeadersDefinition headers = metadata.getHeaders();
        boolean persistent = DeliveryMode.PERSISTENT == headers.getDeliveryMode() || headers.getDeliveryMode() == null;
        try {
            connectionFactory = this.resolver.resolve(connectionFactoryDefinition);
            DestinationDefinition destinationDefinition = metadata.getDestination();
            destination = this.resolver.resolve(destinationDefinition, connectionFactory);
        }
        catch (JmsResolutionException e) {
            throw new ConnectionAttachException((Throwable)((Object)e));
        }
        for (EventStream stream : connection.getEventStreams()) {
            JmsEventStreamHandler handler = new JmsEventStreamHandler(destination, connectionFactory, persistent);
            stream.addHandler((EventStreamHandler)handler);
        }
    }

    public void detach(PhysicalConnectionSourceDefinition source, JmsConnectionTargetDefinition target) throws ConnectionAttachException {
        try {
            this.resolver.release(target.getMetadata().getConnectionFactory());
        }
        catch (JmsResolutionException e) {
            throw new ConnectionAttachException((Throwable)((Object)e));
        }
    }
}

