/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.transaction.TransactionManager;
import org.fabric3.binding.jms.runtime.InterceptorConfiguration;
import org.fabric3.binding.jms.runtime.JmsInterceptor;
import org.fabric3.binding.jms.runtime.ResponseListener;
import org.fabric3.binding.jms.runtime.WireConfiguration;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CorrelationScheme;
import org.fabric3.binding.jms.spi.common.DeliveryMode;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.DestinationType;
import org.fabric3.binding.jms.spi.common.HeadersDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.OperationPropertiesDefinition;
import org.fabric3.binding.jms.spi.provision.JmsTargetDefinition;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.spi.binding.handler.BindingHandler;
import org.fabric3.spi.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsTargetWireAttacher
implements TargetWireAttacher<JmsTargetDefinition> {
    private AdministeredObjectResolver resolver;
    private TransactionManager tm;
    private ClassLoaderRegistry classLoaderRegistry;
    private BindingHandlerRegistry handlerRegistry;

    public JmsTargetWireAttacher(@Reference AdministeredObjectResolver resolver, @Reference TransactionManager tm, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference BindingHandlerRegistry handlerRegistry) {
        this.resolver = resolver;
        this.tm = tm;
        this.classLoaderRegistry = classLoaderRegistry;
        this.handlerRegistry = handlerRegistry;
    }

    public void attach(PhysicalSourceDefinition source, JmsTargetDefinition target, Wire wire) throws WiringException {
        WireConfiguration wireConfiguration = new WireConfiguration();
        ClassLoader targetClassLoader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
        wireConfiguration.setClassloader(targetClassLoader);
        wireConfiguration.setTransactionManager(this.tm);
        wireConfiguration.setCorrelationScheme(target.getMetadata().getCorrelationScheme());
        wireConfiguration.setResponseTimeout(target.getMetadata().getResponseTimeout());
        wireConfiguration.setTransactionType(target.getTransactionType());
        JmsBindingMetadata metadata = target.getMetadata();
        HeadersDefinition headers = metadata.getHeaders();
        boolean persistent = DeliveryMode.PERSISTENT == headers.getDeliveryMode() || headers.getDeliveryMode() == null;
        wireConfiguration.setPersistent(persistent);
        this.resolveAdministeredObjects(target, wireConfiguration);
        List<BindingHandler<Message>> handlers = this.createHandlers(target);
        List<OperationPayloadTypes> types = target.getPayloadTypes();
        for (InvocationChain chain : wire.getInvocationChains()) {
            InterceptorConfiguration configuration = new InterceptorConfiguration(wireConfiguration);
            PhysicalOperationDefinition op = chain.getPhysicalOperation();
            String operationName = op.getName();
            configuration.setOperationName(operationName);
            configuration.setOneWay(op.isOneWay());
            this.processJmsHeaders(configuration, metadata);
            OperationPayloadTypes payloadTypes = this.resolveOperation(operationName, types);
            configuration.setPayloadType(payloadTypes);
            JmsInterceptor interceptor = new JmsInterceptor(configuration, handlers);
            target.getMetadata().getDestination().getName();
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalSourceDefinition source, JmsTargetDefinition target) throws WiringException {
        try {
            this.resolver.release(target.getMetadata().getConnectionFactory());
        }
        catch (JmsResolutionException e) {
            throw new WiringException((Throwable)((Object)e));
        }
    }

    public ObjectFactory<?> createObjectFactory(JmsTargetDefinition target) throws WiringException {
        throw new UnsupportedOperationException();
    }

    private void processJmsHeaders(InterceptorConfiguration configuration, JmsBindingMetadata metadata) throws WiringException {
        HeadersDefinition uriHeaders = metadata.getUriHeaders();
        HeadersDefinition headers = metadata.getHeaders();
        Map<String, OperationPropertiesDefinition> properties = metadata.getOperationProperties();
        this.setBindingHeaders(configuration, uriHeaders);
        OperationPropertiesDefinition definition = properties.get(configuration.getOperationName());
        if (definition != null) {
            this.setOperationHeaders(configuration, definition);
        }
        this.setBindingHeaders(configuration, headers);
    }

    private void setBindingHeaders(InterceptorConfiguration configuration, HeadersDefinition headers) {
        long timeToLive;
        int priority;
        DeliveryMode deliveryMode;
        String type = headers.getJmsType();
        if (type != null && configuration.getJmsType() != null) {
            configuration.setJmsType(type);
        }
        if ((deliveryMode = headers.getDeliveryMode()) != null && configuration.getDeliveryMode() == -1) {
            this.setDeliveryMode(deliveryMode.toString(), configuration);
        }
        if ((priority = headers.getPriority()) >= 0 && configuration.getPriority() == -1) {
            configuration.setPriority(priority);
        }
        if ((timeToLive = headers.getTimeToLive()) >= 0L && configuration.getTimeToLive() == -1L) {
            configuration.setTimeToLive(timeToLive);
        }
        for (Map.Entry<String, String> entry : headers.getProperties().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (configuration.getProperties().containsKey(key)) continue;
            configuration.addProperty(key, value);
        }
    }

    private void setOperationHeaders(InterceptorConfiguration configuration, OperationPropertiesDefinition definition) throws WiringException {
        for (Map.Entry<String, String> entry : definition.getProperties().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (configuration.getJmsType() == null && "JMSType".equals(key)) {
                if (configuration.getJmsType() == null) continue;
                configuration.setJmsType(value);
                continue;
            }
            if (configuration.getDeliveryMode() == -1 && "JMSDeliveryMode".equals(key)) {
                this.setDeliveryMode(value, configuration);
                continue;
            }
            if (configuration.getTimeToLive() == -1L && "JMSTimeToLive".equals(key)) {
                try {
                    long time = Long.valueOf(value);
                    configuration.setTimeToLive(time);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new WiringException((Throwable)e);
                }
            }
            if (configuration.getPriority() == -1 && "JMSPriority".equals(key)) {
                try {
                    int priority = Integer.valueOf(value);
                    configuration.setPriority(priority);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new WiringException((Throwable)e);
                }
            }
            configuration.addProperty(key, value);
        }
    }

    private void setDeliveryMode(String value, InterceptorConfiguration configuration) {
        if ("persistent".equalsIgnoreCase(value)) {
            configuration.setDeliveryMode(2);
        } else if ("nonpersistent".equalsIgnoreCase(value)) {
            configuration.setDeliveryMode(1);
        }
    }

    private void resolveAdministeredObjects(JmsTargetDefinition target, WireConfiguration wireConfiguration) throws WiringException {
        JmsBindingMetadata metadata = target.getMetadata();
        ConnectionFactoryDefinition connectionFactoryDefinition = metadata.getConnectionFactory();
        try {
            DestinationDefinition callbackDestinationDefinition;
            ConnectionFactory requestConnectionFactory = this.resolver.resolve(connectionFactoryDefinition);
            DestinationDefinition destinationDefinition = metadata.getDestination();
            Destination requestDestination = this.resolver.resolve(destinationDefinition, requestConnectionFactory);
            wireConfiguration.setRequestConnectionFactory(requestConnectionFactory);
            wireConfiguration.setRequestDestination(requestDestination);
            this.validateDestination(requestDestination, destinationDefinition);
            if (metadata.isResponse()) {
                connectionFactoryDefinition = metadata.getResponseConnectionFactory();
                ConnectionFactory responseConnectionFactory = this.resolver.resolve(connectionFactoryDefinition);
                destinationDefinition = metadata.getResponseDestination();
                Destination responseDestination = this.resolver.resolve(destinationDefinition, responseConnectionFactory);
                CorrelationScheme scheme = metadata.getCorrelationScheme();
                ResponseListener listener = new ResponseListener(responseDestination, scheme);
                wireConfiguration.setResponseListener(listener);
                this.validateDestination(responseDestination, destinationDefinition);
            }
            if ((callbackDestinationDefinition = target.getCallbackDestination()) != null) {
                Destination callbackDestination = this.resolver.resolve(callbackDestinationDefinition, requestConnectionFactory);
                wireConfiguration.setCallbackDestination(callbackDestination);
                if (callbackDestination != null) {
                    String name;
                    if (callbackDestination instanceof Queue) {
                        name = ((Queue)callbackDestination).getQueueName();
                        wireConfiguration.setCallbackUri("jms:" + name);
                    } else if (callbackDestination instanceof Topic) {
                        name = ((Topic)callbackDestination).getTopicName();
                        wireConfiguration.setCallbackUri("jms:" + name);
                    }
                }
            }
        }
        catch (JmsResolutionException e) {
            throw new WiringException((Throwable)((Object)e));
        }
        catch (JMSException e) {
            throw new WiringException((Throwable)e);
        }
    }

    private void validateDestination(Destination requestDestination, DestinationDefinition requestDestinationDefinition) throws WiringException {
        DestinationType requestDestinationType = requestDestinationDefinition.geType();
        if (DestinationType.QUEUE == requestDestinationType && !(requestDestination instanceof Queue)) {
            throw new WiringException("Destination is not a queue: " + requestDestinationDefinition.getName());
        }
        if (DestinationType.TOPIC == requestDestinationType && !(requestDestination instanceof Topic)) {
            throw new WiringException("Destination is not a topic: " + requestDestinationDefinition.getName());
        }
    }

    private OperationPayloadTypes resolveOperation(String operationName, List<OperationPayloadTypes> payloadTypes) {
        for (OperationPayloadTypes type : payloadTypes) {
            if (!type.getName().equals(operationName)) continue;
            return type;
        }
        throw new AssertionError((Object)("Error resolving operation: " + operationName));
    }

    private List<BindingHandler<Message>> createHandlers(JmsTargetDefinition target) {
        if (target.getHandlers().isEmpty()) {
            return null;
        }
        ArrayList<BindingHandler<Message>> handlers = new ArrayList<BindingHandler<Message>>();
        for (PhysicalBindingHandlerDefinition handlerDefinition : target.getHandlers()) {
            BindingHandler handler = this.handlerRegistry.createHandler(Message.class, handlerDefinition);
            handlers.add((BindingHandler<Message>)handler);
        }
        return handlers;
    }
}

