/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.jms.runtime.InvocationChainHolder;
import org.fabric3.binding.jms.runtime.ListenerMonitor;
import org.fabric3.binding.jms.runtime.WireHolder;
import org.fabric3.binding.jms.runtime.common.JmsBadMessageException;
import org.fabric3.binding.jms.runtime.common.MessageHelper;
import org.fabric3.binding.jms.spi.common.CorrelationScheme;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.PayloadType;
import org.fabric3.spi.binding.handler.BindingHandler;
import org.fabric3.spi.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.util.Base64;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.xml.XMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceListener
implements MessageListener {
    private WireHolder wireHolder;
    private Map<String, InvocationChainHolder> invocationChainMap;
    private InvocationChainHolder onMessageHolder;
    private Destination defaultResponseDestination;
    private ConnectionFactory responseFactory;
    private TransactionType transactionType;
    private ClassLoader classLoader;
    private ListenerMonitor monitor;
    private XMLFactory xmlFactory;
    private XMLInputFactory xmlInputFactory;
    private BindingHandlerRegistry handlerRegistry;
    private String bindingName;
    private List<BindingHandler<javax.jms.Message>> handlers;

    public ServiceListener(WireHolder wireHolder, Destination defaultResponseDestination, ConnectionFactory responseFactory, TransactionType transactionType, ClassLoader classLoader, XMLFactory xmlFactory, List<BindingHandler<javax.jms.Message>> handlers, ListenerMonitor monitor) {
        this.wireHolder = wireHolder;
        this.defaultResponseDestination = defaultResponseDestination;
        this.responseFactory = responseFactory;
        this.transactionType = transactionType;
        this.classLoader = classLoader;
        this.xmlFactory = xmlFactory;
        this.handlers = handlers;
        this.monitor = monitor;
        this.invocationChainMap = new HashMap<String, InvocationChainHolder>();
        for (InvocationChainHolder chainHolder : wireHolder.getInvocationChains()) {
            String name = chainHolder.getChain().getPhysicalOperation().getName();
            if ("onMessage".equals(name)) {
                this.onMessageHolder = chainHolder;
            }
            this.invocationChainMap.put(name, chainHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(javax.jms.Message request) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            InvocationChainHolder holder = this.getHolder(request);
            Interceptor interceptor = holder.getChain().getHeadInterceptor();
            boolean oneWay = holder.getChain().getPhysicalOperation().isOneWay();
            OperationPayloadTypes payloadTypes = holder.getPayloadTypes();
            PayloadType inputType = payloadTypes.getInputType();
            Object[] payload = MessageHelper.getPayload(request, inputType);
            switch (inputType) {
                case OBJECT: {
                    if (payload != null && !payload.getClass().isArray()) {
                        payload = new Object[]{payload};
                    }
                    this.invoke(request, interceptor, payload, payloadTypes, oneWay, this.transactionType);
                    return;
                }
                case XML: {
                    this.invoke(request, interceptor, payload, payloadTypes, oneWay, this.transactionType);
                    return;
                }
                case TEXT: {
                    payload = new Object[]{payload};
                    this.invoke(request, interceptor, payload, payloadTypes, oneWay, this.transactionType);
                    return;
                }
                case STREAM: {
                    throw new UnsupportedOperationException();
                }
                default: {
                    payload = new Object[]{payload};
                    this.invoke(request, interceptor, payload, payloadTypes, oneWay, this.transactionType);
                    return;
                }
            }
        }
        catch (JMSException e) {
            this.monitor.redeliveryError(e);
            return;
        }
        catch (JmsBadMessageException e) {
            this.monitor.redeliveryError((Throwable)((Object)e));
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(javax.jms.Message request, Interceptor interceptor, Object payload, OperationPayloadTypes payloadTypes, boolean oneWay, TransactionType transactionType) throws JMSException, JmsBadMessageException {
        WorkContext workContext = this.createWorkContext(request, this.wireHolder.getCallbackUri());
        if (PayloadType.XML == payloadTypes.getInputType()) {
            payload = new Object[]{payload};
        }
        MessageImpl inMessage = new MessageImpl((Object)payload, false, workContext);
        this.applyHandlers(request, (Message)inMessage);
        Message outMessage = interceptor.invoke((Message)inMessage);
        if (oneWay) {
            return;
        }
        Connection connection = null;
        Session responseSession = null;
        try {
            connection = this.responseFactory.createConnection();
            responseSession = TransactionType.GLOBAL == transactionType ? connection.createSession(true, 0) : connection.createSession(false, 1);
            Object responsePayload = outMessage.getBody();
            PayloadType returnType = outMessage.isFault() ? payloadTypes.getFaultType() : payloadTypes.getOutputType();
            javax.jms.Message response = this.createMessage(responsePayload, responseSession, returnType);
            this.sendResponse(request, responseSession, outMessage, response);
        }
        finally {
            if (responseSession != null) {
                responseSession.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void sendResponse(javax.jms.Message request, Session responseSession, Message outMessage, javax.jms.Message response) throws JMSException, JmsBadMessageException {
        MessageProducer producer;
        CorrelationScheme correlationScheme = this.wireHolder.getCorrelationScheme();
        switch (correlationScheme) {
            case CORRELATION_ID: {
                response.setJMSCorrelationID(request.getJMSCorrelationID());
                break;
            }
            case MESSAGE_ID: {
                response.setJMSCorrelationID(request.getJMSMessageID());
            }
        }
        if (outMessage.isFault()) {
            response.setBooleanProperty("f3Fault", true);
        }
        if (request.getJMSReplyTo() != null) {
            producer = responseSession.createProducer(request.getJMSReplyTo());
        } else {
            if (this.defaultResponseDestination == null) {
                throw new JmsBadMessageException("JMSReplyTo must be set as no response destination was configured on the service");
            }
            producer = responseSession.createProducer(this.defaultResponseDestination);
        }
        producer.send(response);
    }

    private javax.jms.Message createMessage(Object payload, Session session, PayloadType payloadType) throws JMSException {
        switch (payloadType) {
            case STREAM: {
                throw new UnsupportedOperationException("Stream message not yet supported");
            }
            case XML: 
            case TEXT: {
                if (payload != null && !(payload instanceof String)) {
                    throw new IllegalArgumentException("Response payload is not a string: " + payload);
                }
                return session.createTextMessage((String)payload);
            }
            case OBJECT: {
                if (payload != null && !(payload instanceof Serializable)) {
                    throw new IllegalArgumentException("Response payload is not serializable: " + payload);
                }
                return session.createObjectMessage((Serializable)payload);
            }
        }
        return MessageHelper.createBytesMessage(session, payload, payloadType);
    }

    private InvocationChainHolder getHolder(javax.jms.Message message) throws JmsBadMessageException, JMSException {
        String opName = message.getStringProperty("scaOperationName");
        List<InvocationChainHolder> chainHolders = this.wireHolder.getInvocationChains();
        if (chainHolders.size() == 1) {
            return chainHolders.get(0);
        }
        if (opName != null) {
            InvocationChainHolder chainHolder = this.invocationChainMap.get(opName);
            if (chainHolder == null) {
                throw new JmsBadMessageException("Unable to match operation on the service contract: " + opName);
            }
            return chainHolder;
        }
        if (this.onMessageHolder != null) {
            return this.onMessageHolder;
        }
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            String payload = textMessage.getText();
            return this.getHolderBasedOnElementName(payload.getBytes());
        }
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            byte[] payload = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(payload);
            return this.getHolderBasedOnElementName(payload);
        }
        throw new JmsBadMessageException("Unable to match operation on the service contract");
    }

    private InvocationChainHolder getHolderBasedOnElementName(byte[] payload) throws JmsBadMessageException {
        if (this.xmlInputFactory == null) {
            this.xmlInputFactory = this.xmlFactory.newInputFactoryInstance();
        }
        try {
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(payload));
            reader.nextTag();
            String name = reader.getName().getLocalPart();
            InvocationChainHolder chainHolder = this.invocationChainMap.get(name);
            if (chainHolder == null) {
                throw new JmsBadMessageException("Unable to match operation on for name: " + name);
            }
            return chainHolder;
        }
        catch (XMLStreamException e) {
            throw new JmsBadMessageException("Unable to process message", e);
        }
    }

    private WorkContext createWorkContext(javax.jms.Message request, String callbackUri) throws JmsBadMessageException {
        try {
            WorkContext workContext = new WorkContext();
            String encoded = request.getStringProperty("f3Context");
            if (encoded == null) {
                return workContext;
            }
            ByteArrayInputStream bas = new ByteArrayInputStream(Base64.decode((String)encoded));
            ObjectInputStream stream = new ObjectInputStream(bas);
            List stack = (List)stream.readObject();
            workContext.addCallFrames(stack);
            stream.close();
            CallFrame previous = workContext.peekCallFrame();
            if (previous != null) {
                Serializable id = previous.getCorrelationId(Serializable.class);
                CallFrame frame = new CallFrame(callbackUri, id);
                stack.add(frame);
            } else {
                workContext.addCallFrame(CallFrame.STATELESS_FRAME);
            }
            return workContext;
        }
        catch (JMSException ex) {
            throw new JmsBadMessageException("Error deserializing callframe", ex);
        }
        catch (IOException ex) {
            throw new JmsBadMessageException("Error deserializing callframe", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new JmsBadMessageException("Error deserializing callframe", ex);
        }
    }

    public void setBindingHandlerRegistry(BindingHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void setBindingName(String name) {
        this.bindingName = name;
    }

    private void applyHandlers(javax.jms.Message request, Message inMessage) {
        if (this.handlers != null) {
            for (BindingHandler<javax.jms.Message> handler : this.handlers) {
                handler.handleInbound((Object)request, inMessage);
            }
        }
    }
}

