/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.transaction.TransactionManager;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.jms.runtime.container.AdaptiveMessageContainer;
import org.fabric3.binding.jms.runtime.container.ConnectionManager;
import org.fabric3.binding.jms.runtime.container.ContainerConfiguration;
import org.fabric3.binding.jms.runtime.container.ContainerManagerMonitor;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.MessageContainerManager;
import org.fabric3.binding.jms.runtime.container.MessageContainerMonitor;
import org.fabric3.binding.jms.runtime.container.UnitOfWork;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.RuntimeStart;
import org.fabric3.spi.event.RuntimeStop;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.transport.Transport;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@EagerInit
@Service(names={MessageContainerManager.class, Transport.class})
public class MessageContainerManagerImpl
implements MessageContainerManager,
Transport {
    private static final int DEFAULT_TRX_TIMEOUT = 30;
    private Map<URI, AdaptiveMessageContainer> containers = new ConcurrentHashMap<URI, AdaptiveMessageContainer>();
    private boolean started;
    private boolean pausedOnStart;
    private EventService eventService;
    private ExecutorService executorService;
    private TransactionManager tm;
    private MessageContainerMonitor containerMonitor;
    private ManagementService managementService;
    private ContainerManagerMonitor managerMonitor;
    private int transactionTimeout = 30;

    public MessageContainerManagerImpl(@Reference EventService eventService, @Reference ExecutorService executorService, @Reference TransactionManager tm, @Reference ManagementService managementService, @Monitor MessageContainerMonitor containerMonitor, @Monitor ContainerManagerMonitor managerMonitor) {
        this.eventService = eventService;
        this.executorService = executorService;
        this.tm = tm;
        this.managementService = managementService;
        this.containerMonitor = containerMonitor;
        this.managerMonitor = managerMonitor;
    }

    @Property(required=false)
    public void setTransactionTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Invalid transaction timeout: " + timeout);
        }
        this.transactionTimeout = timeout;
    }

    @Property(required=false)
    public void setPauseOnStart(boolean pauseOnStart) {
        this.pausedOnStart = pauseOnStart;
    }

    @Init
    public void init() {
        this.eventService.subscribe(RuntimeStart.class, (Fabric3EventListener)new StartEventListener());
        this.eventService.subscribe(RuntimeStop.class, (Fabric3EventListener)new StopEventListener());
    }

    @Destroy
    public void destroy() throws JMSException {
        this.started = false;
    }

    public void suspend() {
        if (!this.started) {
            return;
        }
        for (Map.Entry<URI, AdaptiveMessageContainer> entry : this.containers.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (JMSException e) {
                this.managerMonitor.stopError(entry.getKey(), e);
            }
        }
        this.started = false;
    }

    public void resume() {
        if (this.started) {
            return;
        }
        for (Map.Entry<URI, AdaptiveMessageContainer> entry : this.containers.entrySet()) {
            try {
                if (this.pausedOnStart) {
                    entry.getValue().initialize();
                    continue;
                }
                entry.getValue().start();
            }
            catch (JMSException e) {
                this.managerMonitor.startError(entry.getKey(), e);
            }
        }
        this.pausedOnStart = false;
        this.started = true;
    }

    public boolean isRegistered(URI serviceUri) {
        return this.containers.containsKey(serviceUri);
    }

    public void register(ContainerConfiguration configuration) throws JMSException {
        URI uri = configuration.getUri();
        if (this.containers.containsKey(uri)) {
            throw new JMSException("Container already registered: " + uri);
        }
        ConnectionFactory factory = configuration.getFactory();
        TransactionType type = configuration.getType();
        String clientId = configuration.getClientId();
        boolean durable = configuration.isDurable();
        int cacheLevel = configuration.getCacheLevel();
        boolean cacheConnection = cacheLevel >= 1;
        int receiveTimeout = this.transactionTimeout / 2;
        ContainerStatistics statistics = new ContainerStatistics();
        ConnectionManager connectionManager = new ConnectionManager(factory, uri, clientId, cacheConnection, durable, this.containerMonitor);
        UnitOfWork transactionHelper = new UnitOfWork(uri, type, this.transactionTimeout, this.tm, statistics);
        AdaptiveMessageContainer container = new AdaptiveMessageContainer(configuration, receiveTimeout, connectionManager, transactionHelper, statistics, this.executorService, this.containerMonitor);
        this.containers.put(uri, container);
        try {
            String encodedName = this.encodeName(uri);
            String encodedGroup = this.encodeGroup(uri);
            this.managementService.export(encodedName, encodedGroup, "JMS message container", (Object)container);
        }
        catch (ManagementException e) {
            throw new JMSException(e.getMessage());
        }
        if (this.started) {
            container.initialize();
            this.managerMonitor.registerListener(uri);
        }
    }

    public void unregister(URI uri) throws JMSException {
        AdaptiveMessageContainer container = this.containers.remove(uri);
        if (container != null) {
            container.shutdown();
            try {
                String encodedName = this.encodeName(uri);
                String encodedGroup = this.encodeGroup(uri);
                this.managementService.remove(encodedName, encodedGroup);
            }
            catch (ManagementException e) {
                throw new JMSException(e.getMessage());
            }
            this.managerMonitor.unRegisterListener(uri);
        }
    }

    private String encodeName(URI uri) {
        return "transports/jms/consumers/" + UriHelper.getBaseName((URI)uri).replace("#", "/").toLowerCase();
    }

    private String encodeGroup(URI uri) {
        String path = uri.getPath();
        if (path.length() != 0) {
            return "JMS/message containers/" + path.substring(1);
        }
        return "JMS/message containers/" + uri.getAuthority();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StopEventListener
    implements Fabric3EventListener<RuntimeStop> {
        private StopEventListener() {
        }

        public void onEvent(RuntimeStop event) {
            for (Map.Entry entry : MessageContainerManagerImpl.this.containers.entrySet()) {
                try {
                    ((AdaptiveMessageContainer)entry.getValue()).stop();
                }
                catch (JMSException e) {
                    MessageContainerManagerImpl.this.managerMonitor.stopError((URI)entry.getKey(), e);
                }
            }
            for (Map.Entry entry : MessageContainerManagerImpl.this.containers.entrySet()) {
                try {
                    ((AdaptiveMessageContainer)entry.getValue()).shutdown();
                }
                catch (JMSException e) {
                    MessageContainerManagerImpl.this.managerMonitor.stopError((URI)entry.getKey(), e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartEventListener
    implements Fabric3EventListener<RuntimeStart> {
        private StartEventListener() {
        }

        public void onEvent(RuntimeStart event) {
            for (Map.Entry entry : MessageContainerManagerImpl.this.containers.entrySet()) {
                try {
                    if (!MessageContainerManagerImpl.this.pausedOnStart) {
                        ((AdaptiveMessageContainer)entry.getValue()).initialize();
                    }
                    MessageContainerManagerImpl.this.managerMonitor.registerListener((URI)entry.getKey());
                }
                catch (JMSException e) {
                    MessageContainerManagerImpl.this.managerMonitor.startError((URI)entry.getKey(), e);
                }
            }
            if (!MessageContainerManagerImpl.this.pausedOnStart) {
                MessageContainerManagerImpl.this.started = true;
            }
        }
    }
}

