/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.TransactionException;
import org.fabric3.binding.jms.spi.common.TransactionType;

public class UnitOfWork {
    private URI listenerUri;
    private TransactionType transactionType;
    private int transactionTimeout;
    private TransactionManager tm;
    private ContainerStatistics statistics;

    public UnitOfWork(URI listenerUri, TransactionType type, int timeout, TransactionManager tm, ContainerStatistics statistics) {
        this.listenerUri = listenerUri;
        this.transactionTimeout = timeout;
        this.transactionType = type;
        this.tm = tm;
        this.statistics = statistics;
    }

    public void begin() throws TransactionException {
        if (TransactionType.GLOBAL != this.transactionType) {
            return;
        }
        try {
            this.tm.begin();
            this.tm.setTransactionTimeout(this.transactionTimeout);
        }
        catch (NotSupportedException e) {
            throw new TransactionException(e);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    public void end(Session session, Message message) throws TransactionException {
        if (TransactionType.GLOBAL == this.transactionType) {
            this.globalCommit();
        } else {
            this.localCommitOrAcknowledge(session, message);
        }
    }

    public void rollback(Session session) throws TransactionException {
        if (TransactionType.GLOBAL == this.transactionType) {
            this.globalRollback();
        } else {
            try {
                this.localRollback(session);
            }
            catch (JMSException e) {
                throw new TransactionException(e);
            }
        }
    }

    private void globalCommit() throws TransactionException {
        try {
            if (this.tm.getStatus() != 1) {
                this.tm.commit();
                this.statistics.incrementTransactions();
            } else {
                this.tm.rollback();
                this.statistics.incrementTransactionsRolledBack();
            }
        }
        catch (SystemException e) {
            throw new TransactionException("Error handling message for " + this.listenerUri, e);
        }
        catch (IllegalStateException e) {
            throw new TransactionException("Error handling message for " + this.listenerUri, e);
        }
        catch (SecurityException e) {
            throw new TransactionException("Error handling message for " + this.listenerUri, e);
        }
        catch (HeuristicMixedException e) {
            throw new TransactionException("Error handling message for " + this.listenerUri, e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionException("Error handling message for " + this.listenerUri, e);
        }
        catch (RollbackException e) {
            throw new TransactionException("Error handling message for " + this.listenerUri, e);
        }
    }

    private void localCommitOrAcknowledge(Session session, Message message) throws TransactionException {
        try {
            if (TransactionType.SESSION == this.transactionType) {
                session.commit();
                this.statistics.incrementTransactions();
            } else if (2 == session.getAcknowledgeMode()) {
                message.acknowledge();
            }
        }
        catch (JMSException e) {
            throw new TransactionException(e);
        }
    }

    private void globalRollback() throws TransactionException {
        try {
            if (this.tm.getStatus() != 6) {
                this.tm.rollback();
                this.statistics.incrementTransactionsRolledBack();
            }
        }
        catch (SystemException e) {
            throw new TransactionException("Error reverting transaction for " + this.listenerUri, e);
        }
    }

    private void localRollback(Session session) throws JMSException {
        if (TransactionType.SESSION == this.transactionType) {
            session.rollback();
            this.statistics.incrementTransactionsRolledBack();
        }
    }
}

