/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver;

import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.runtime.resolver.DestinationStrategy;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CreateOption;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdministeredObjectResolverImpl
implements AdministeredObjectResolver {
    private Map<CreateOption, ConnectionFactoryStrategy> factoryStrategies = new HashMap<CreateOption, ConnectionFactoryStrategy>();
    private Map<CreateOption, DestinationStrategy> destinationStrategies = new HashMap<CreateOption, DestinationStrategy>();

    public AdministeredObjectResolverImpl(@Reference Map<CreateOption, ConnectionFactoryStrategy> factoryStrategies, @Reference Map<CreateOption, DestinationStrategy> destinationStrategies) {
        this.factoryStrategies = factoryStrategies;
        this.destinationStrategies = destinationStrategies;
    }

    @Override
    public ConnectionFactory resolve(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        CreateOption create = definition.getCreate();
        ConnectionFactoryStrategy strategy = this.getConnectionFactory(create);
        return strategy.getConnectionFactory(definition);
    }

    @Override
    public Destination resolve(DestinationDefinition definition, ConnectionFactory factory) throws JmsResolutionException {
        return this.resolve(definition, null, factory);
    }

    @Override
    public Destination resolve(DestinationDefinition definition, String clientId, ConnectionFactory factory) throws JmsResolutionException {
        CreateOption create = definition.getCreate();
        DestinationStrategy strategy = this.destinationStrategies.get((Object)create);
        if (strategy == null) {
            throw new AssertionError((Object)("DestinationStrategy not configured: " + (Object)((Object)create)));
        }
        return strategy.getDestination(definition, clientId, factory);
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        CreateOption create = definition.getCreate();
        ConnectionFactoryStrategy strategy = this.getConnectionFactory(create);
        strategy.release(definition);
    }

    private ConnectionFactoryStrategy getConnectionFactory(CreateOption create) {
        ConnectionFactoryStrategy strategy = this.factoryStrategies.get((Object)create);
        if (strategy == null) {
            throw new AssertionError((Object)("ConnectionFactoryStrategy not configured: " + (Object)((Object)create)));
        }
        return strategy;
    }
}

