/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.binding.jms.spi.runtime.ProviderConnectionFactoryCreator;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlwaysConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryManager manager;
    private ProviderConnectionFactoryCreator creator;
    private Set<String> created = new HashSet<String>();

    public AlwaysConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.manager = manager;
    }

    @Reference(required=false)
    public void setCreator(ProviderConnectionFactoryCreator creator) {
        this.creator = creator;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        ConnectionFactory factory;
        Map<String, String> props = definition.getProperties();
        String className = props.get("class");
        String name = definition.getName();
        String templateName = definition.getTemplateName();
        if (className == null) {
            if (this.creator == null) {
                throw new JmsResolutionException("A connection factory class was not specified for: " + name);
            }
            factory = this.creator.create(templateName);
        } else {
            factory = this.instantiate(className, props);
        }
        this.created.add(name);
        return this.manager.register(name, factory);
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        String name = definition.getName();
        if (this.created.remove(name)) {
            ConnectionFactory factory = this.manager.unregister(name);
            if (factory == null) {
                throw new JmsResolutionException("Connection factory not found: " + name);
            }
            this.creator.release(factory);
        }
    }

    private ConnectionFactory instantiate(String className, Map<String, String> props) throws JmsResolutionException {
        try {
            ConnectionFactory factory = (ConnectionFactory)Class.forName(className).newInstance();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(factory.getClass()).getPropertyDescriptors()) {
                String propName = pd.getName();
                String propValue = props.get(propName);
                Method writeMethod = pd.getWriteMethod();
                if (propValue == null || writeMethod == null) continue;
                writeMethod.invoke((Object)factory, propValue);
            }
            return factory;
        }
        catch (InstantiationException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + className, e);
        }
        catch (IntrospectionException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + className, e);
        }
    }
}

