/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.util.List;
import javax.jms.ConnectionFactory;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.runtime.resolver.connectionfactory.AlwaysConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.binding.jms.spi.runtime.ProviderConnectionFactoryCreator;
import org.fabric3.binding.jms.spi.runtime.ProviderConnectionFactoryResolver;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfNotExistConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private AlwaysConnectionFactoryStrategy always;
    private ConnectionFactoryManager manager;
    private List<ProviderConnectionFactoryResolver> resolvers;

    public IfNotExistConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.always = new AlwaysConnectionFactoryStrategy(manager);
        this.manager = manager;
    }

    @Reference(required=false)
    public void setResolvers(List<ProviderConnectionFactoryResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Reference(required=false)
    public void setCreator(ProviderConnectionFactoryCreator creator) {
        this.always.setCreator(creator);
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        String name = definition.getName();
        if (name != null) {
            ConnectionFactory factory = this.manager.get(name);
            if (factory != null) {
                return factory;
            }
            for (ProviderConnectionFactoryResolver resolver : this.resolvers) {
                factory = resolver.resolve(definition);
                if (factory == null) continue;
                return factory;
            }
        }
        return this.always.getConnectionFactory(definition);
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        this.always.release(definition);
    }
}

