/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.binding.jms.spi.runtime.ProviderConnectionFactoryResolver;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeverConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryManager manager;
    private List<ProviderConnectionFactoryResolver> resolvers;

    public NeverConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.manager = manager;
    }

    @Reference(required=false)
    public void setResolvers(List<ProviderConnectionFactoryResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        String name = definition.getName();
        try {
            ProviderConnectionFactoryResolver resolver;
            ConnectionFactory factory = this.manager.get(name);
            if (factory != null) {
                return factory;
            }
            Iterator<ProviderConnectionFactoryResolver> i$ = this.resolvers.iterator();
            while (i$.hasNext() && (factory = (resolver = i$.next()).resolve(definition)) == null) {
            }
            return this.manager.register(name, factory, Collections.<String, String>emptyMap());
        }
        catch (FactoryRegistrationException e) {
            throw new JmsResolutionException("Error resolving connection factory: " + name, (Throwable)((Object)e));
        }
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws JmsResolutionException {
    }
}

