/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.ds;

import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.datasource.spi.DataSourceRegistry;
import org.fabric3.runtime.weblogic.api.Constants;
import org.fabric3.runtime.weblogic.ds.DataSourceResolverMonitor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DataSourceResolver {
    private DataSourceRegistry registry;
    private MBeanServer mbServer;
    private DataSourceResolverMonitor monitor;
    private Set<String> previousDataSources = new HashSet<String>();

    public DataSourceResolver(@Reference DataSourceRegistry registry, @Reference MBeanServer mbServer, @Monitor DataSourceResolverMonitor monitor) {
        this.registry = registry;
        this.mbServer = mbServer;
        this.monitor = monitor;
    }

    @Init
    public void init() throws JMException, NamingException {
        this.updateDataSources(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataSources(boolean initialize) throws NamingException, JMException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            ObjectName domainConfig = (ObjectName)this.mbServer.getAttribute(Constants.WLS_RUNTIME_SERVICE_MBEAN, "DomainConfiguration");
            ObjectName[] systemResources = (ObjectName[])this.mbServer.getAttribute(domainConfig, "JDBCSystemResources");
            if (initialize) {
                this.mbServer.addNotificationListener(domainConfig, new DataSourceChangeListener(), null, null);
            }
            HashSet<String> newDataSources = new HashSet<String>();
            for (ObjectName systemResource : systemResources) {
                ObjectName resource = (ObjectName)this.mbServer.getAttribute(systemResource, "JDBCResource");
                ObjectName params = (ObjectName)this.mbServer.getAttribute(resource, "JDBCDataSourceParams");
                String[] jndiNames = (String[])this.mbServer.getAttribute(params, "JNDINames");
                this.registerDataSources(jndiNames, newDataSources, context);
            }
            for (String previous : this.previousDataSources) {
                if (newDataSources.contains(previous)) continue;
                this.monitor.removeDatasource(previous);
                this.registry.unregister(previous);
            }
            this.previousDataSources = newDataSources;
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private void registerDataSources(String[] jndiNames, Set<String> newDataSources, InitialContext context) throws NamingException {
        for (String name : jndiNames) {
            try {
                DataSource dataSource = (DataSource)context.lookup(name);
                this.monitor.registerDatasource(name);
                newDataSources.add(name);
                this.registry.register(name, dataSource);
            }
            catch (NameNotFoundException e) {
                this.monitor.dataSourceNotFound(name);
            }
        }
    }

    private class DataSourceChangeListener
    implements NotificationListener {
        private DataSourceChangeListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            if (!(notification instanceof AttributeChangeNotification)) {
                return;
            }
            AttributeChangeNotification change = (AttributeChangeNotification)notification;
            if (!"JDBCSystemResources".equals(change.getAttributeName())) {
                return;
            }
            try {
                DataSourceResolver.this.updateDataSources(false);
            }
            catch (JMException e) {
                DataSourceResolver.this.monitor.error(e);
            }
            catch (NamingException e) {
                DataSourceResolver.this.monitor.error(e);
            }
        }
    }
}

