/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.runtime.weblogic.api.Constants;
import org.fabric3.runtime.weblogic.api.ServletRequestDispatcher;
import org.fabric3.runtime.weblogic.servlet.ServletHostInitException;
import org.fabric3.spi.host.ServletHost;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@Service(names={ServletHost.class, ServletRequestDispatcher.class})
@EagerInit
public class WebLogicServletHost
extends HttpServlet
implements ServletHost,
ServletRequestDispatcher {
    private static final long serialVersionUID = -3784698338450289318L;
    private MBeanServer mBeanServer;
    private Map<String, Servlet> servlets = new ConcurrentHashMap<String, Servlet>();
    private int httpPort;
    private int httpsPort;
    private AtomicBoolean initialized = new AtomicBoolean();
    private ServletConfig config;

    public WebLogicServletHost(@Reference MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Init
    public void start() throws JMException, ServletHostInitException, MalformedURLException {
        ObjectName serverRuntimeMBean = (ObjectName)this.mBeanServer.getAttribute(Constants.WLS_RUNTIME_SERVICE_MBEAN, "ServerRuntime");
        String httpUrl = (String)this.mBeanServer.invoke(serverRuntimeMBean, "getURL", new Object[]{"http"}, new String[]{String.class.getName()});
        if (httpUrl == null) {
            throw new ServletHostInitException("HTTP port not configured");
        }
        this.httpPort = new URL(httpUrl).getPort();
        String httpsUrl = (String)this.mBeanServer.invoke(serverRuntimeMBean, "getURL", new Object[]{"https"}, new String[]{String.class.getName()});
        if (httpsUrl == null) {
            return;
        }
        this.httpsPort = new URL(httpsUrl).getPort();
    }

    public String getHostType() {
        return "WebLogic";
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public boolean isHttpsEnabled() {
        return true;
    }

    public void init(ServletConfig config) throws ServletException {
        for (Servlet servlet : this.servlets.values()) {
            servlet.init(config);
        }
        this.config = config;
        this.initialized.set(true);
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null) {
            this.notFound(resp);
            return;
        }
        Servlet servlet = this.servlets.get(path);
        if (servlet == null) {
            servlet = this.servlets.get(path + "/*");
            if (servlet == null) {
                int i;
                while ((i = path.lastIndexOf("/")) >= 0 && (servlet = this.servlets.get(path.substring(0, i) + "/*")) == null) {
                    path = path.substring(0, i);
                }
            }
            if (servlet == null) {
                this.notFound(resp);
                return;
            }
        }
        servlet.service((ServletRequest)req, (ServletResponse)resp);
    }

    public void registerMapping(String path, Servlet servlet) {
        if (this.servlets.containsKey(path)) {
            throw new IllegalStateException("Servlet already registered at path: " + path);
        }
        if (this.initialized.get()) {
            try {
                servlet.init(this.config);
            }
            catch (ServletException e) {
                this.log("Error initializing servlet for path: " + path, e);
            }
        }
        this.servlets.put(path, servlet);
    }

    public boolean isMappingRegistered(String mapping) {
        return this.servlets.containsKey(mapping);
    }

    public Servlet unregisterMapping(String path) {
        return this.servlets.remove(path);
    }

    private void notFound(HttpServletResponse resp) throws IOException {
        resp.setStatus(404);
        PrintWriter writer = resp.getWriter();
        writer.print("Resource not found");
        writer.close();
    }
}

