/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.security.impl;

import java.util.Collection;
import org.fabric3.api.SecuritySubject;
import org.fabric3.spi.security.AuthorizationException;
import org.fabric3.spi.security.AuthorizationService;
import org.fabric3.spi.security.BasicSecuritySubject;
import org.fabric3.spi.security.NotAuthorizedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationServiceImpl
implements AuthorizationService {
    public void checkRole(SecuritySubject subject, String role) throws AuthorizationException {
        BasicSecuritySubject basicSubject = (BasicSecuritySubject)subject.getDelegate(BasicSecuritySubject.class);
        if (!basicSubject.hasRole(role)) {
            throw new NotAuthorizedException("Subject not authorized for role: " + role);
        }
    }

    public void checkRoles(SecuritySubject subject, Collection<String> roles) throws AuthorizationException {
        BasicSecuritySubject basicSubject = (BasicSecuritySubject)subject.getDelegate(BasicSecuritySubject.class);
        for (String role : roles) {
            if (basicSubject.hasRole(role)) continue;
            throw new NotAuthorizedException("Subject not authorized for role");
        }
    }

    public void checkPermission(SecuritySubject subject, String role) throws AuthorizationException {
        throw new UnsupportedOperationException();
    }

    public void checkPermissions(SecuritySubject subject, Collection<String> roles) throws AuthorizationException {
        throw new UnsupportedOperationException();
    }
}

