/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.introspection;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.fabric3.databinding.jaxb.mapper.JAXBQNameMapper;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.contract.OperationIntrospector;
import org.fabric3.spi.model.type.java.JavaType;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBTypeIntrospector
implements OperationIntrospector {
    private static final String DEFAULT = "##default";
    private static final Map<Class, QName> JAXB_MAPPING = new IdentityHashMap<Class, QName>();
    private JAXBQNameMapper mapper;

    public JAXBTypeIntrospector(@Reference JAXBQNameMapper mapper) {
        this.mapper = mapper;
    }

    public void introspect(Operation operation, Method method, IntrospectionContext context) {
        List inputTypes = operation.getInputTypes();
        for (DataType type : inputTypes) {
            if (!(type instanceof JavaType)) {
                throw new AssertionError((Object)("Java contracts must use " + JavaType.class));
            }
            this.introspectJAXB((JavaType)type);
        }
        for (DataType type : operation.getFaultTypes()) {
            if (!(type instanceof JavaType)) {
                throw new AssertionError((Object)("Java contracts must use " + JavaType.class));
            }
            this.introspectJAXB((JavaType)type);
        }
        DataType outputType = operation.getOutputType();
        if (!(outputType instanceof JavaType)) {
            throw new AssertionError((Object)("Java contracts must use " + JavaType.class));
        }
        this.introspectJAXB((JavaType)outputType);
    }

    private void introspectJAXB(JavaType<?> dataType) {
        Class physical = dataType.getPhysical();
        QName xsdName = JAXB_MAPPING.get(physical);
        if (xsdName != null) {
            dataType.setXsdType(xsdName);
            return;
        }
        XmlRootElement annotation = physical.getAnnotation(XmlRootElement.class);
        if (annotation != null) {
            String namespace = annotation.namespace();
            if (DEFAULT.equals(namespace)) {
                namespace = this.getDefaultNamespace(physical);
            }
            String name = annotation.name();
            if (DEFAULT.equals(namespace)) {
                name = Introspector.decapitalize(physical.getSimpleName());
            }
            xsdName = new QName(namespace, name);
            dataType.setXsdType(xsdName);
            return;
        }
        XmlType typeAnnotation = physical.getAnnotation(XmlType.class);
        if (typeAnnotation != null) {
            String namespace = typeAnnotation.namespace();
            if (DEFAULT.equals(namespace)) {
                namespace = this.getDefaultNamespace(physical);
            }
            String name = typeAnnotation.name();
            if (DEFAULT.equals(namespace)) {
                name = Introspector.decapitalize(physical.getSimpleName());
            }
            xsdName = new QName(namespace, name);
            dataType.setXsdType(xsdName);
            return;
        }
        xsdName = this.mapper.deriveQName(physical);
        dataType.setXsdType(xsdName);
    }

    private String getDefaultNamespace(Class clazz) {
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            XmlSchema schemaAnnotation = pkg.getAnnotation(XmlSchema.class);
            if (schemaAnnotation != null) {
                return schemaAnnotation.namespace();
            }
            return pkg.getName();
        }
        return "";
    }

    static {
        JAXB_MAPPING.put(Boolean.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        JAXB_MAPPING.put(Byte.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "byte"));
        JAXB_MAPPING.put(Short.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "short"));
        JAXB_MAPPING.put(Integer.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "int"));
        JAXB_MAPPING.put(Long.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "long"));
        JAXB_MAPPING.put(Float.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "float"));
        JAXB_MAPPING.put(Double.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "double"));
        JAXB_MAPPING.put(Boolean.class, new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        JAXB_MAPPING.put(Byte.class, new QName("http://www.w3.org/2001/XMLSchema", "byte"));
        JAXB_MAPPING.put(Short.class, new QName("http://www.w3.org/2001/XMLSchema", "short"));
        JAXB_MAPPING.put(Integer.class, new QName("http://www.w3.org/2001/XMLSchema", "int"));
        JAXB_MAPPING.put(Long.class, new QName("http://www.w3.org/2001/XMLSchema", "long"));
        JAXB_MAPPING.put(Float.class, new QName("http://www.w3.org/2001/XMLSchema", "float"));
        JAXB_MAPPING.put(Double.class, new QName("http://www.w3.org/2001/XMLSchema", "double"));
        JAXB_MAPPING.put(String.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        JAXB_MAPPING.put(BigInteger.class, new QName("http://www.w3.org/2001/XMLSchema", "integer"));
        JAXB_MAPPING.put(BigDecimal.class, new QName("http://www.w3.org/2001/XMLSchema", "decimal"));
        JAXB_MAPPING.put(Calendar.class, new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        JAXB_MAPPING.put(Date.class, new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        JAXB_MAPPING.put(QName.class, new QName("http://www.w3.org/2001/XMLSchema", "QName"));
        JAXB_MAPPING.put(URI.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        JAXB_MAPPING.put(XMLGregorianCalendar.class, new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType"));
        JAXB_MAPPING.put(Duration.class, new QName("http://www.w3.org/2001/XMLSchema", "duration"));
        JAXB_MAPPING.put(Object.class, new QName("http://www.w3.org/2001/XMLSchema", "anyType"));
        JAXB_MAPPING.put(Image.class, new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        JAXB_MAPPING.put(DataHandler.class, new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        JAXB_MAPPING.put(Source.class, new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        JAXB_MAPPING.put(UUID.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        JAXB_MAPPING.put(byte[].class, new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
    }
}

