/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.transform;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValue2JAXBTransformer
implements Transformer<Node, Object> {
    private JAXBContext jaxbContext;

    public PropertyValue2JAXBTransformer(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public Object transform(Node source, ClassLoader loader) throws TransformationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            if ("value".equals(source.getNodeName()) || "key".equals(source.getNodeName())) {
                NodeList children = source.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (!(children.item(i) instanceof Element)) continue;
                    Object object = this.jaxbContext.createUnmarshaller().unmarshal(children.item(i));
                    return object;
                }
                throw new TransformationException("Unexpected content");
            }
            Object children = this.jaxbContext.createUnmarshaller().unmarshal(source);
            return children;
        }
        catch (JAXBException e) {
            throw new TransformationException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

