/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.generator;

import java.net.URI;
import org.fabric3.host.Names;
import org.fabric3.monitor.model.MonitorResourceReference;
import org.fabric3.monitor.provision.MonitorTargetDefinition;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.generator.ResourceReferenceGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class MonitorResourceReferenceGenerator
implements ResourceReferenceGenerator<MonitorResourceReference> {
    public MonitorTargetDefinition generateWireTarget(LogicalResourceReference<MonitorResourceReference> resourceReference) throws GenerationException {
        URI channelUri;
        LogicalComponent component = (LogicalComponent)resourceReference.getParent();
        String type = ((MonitorResourceReference)resourceReference.getDefinition()).getServiceContract().getQualifiedInterfaceName();
        URI monitorable = component.getUri();
        String channelName = ((MonitorResourceReference)resourceReference.getDefinition()).getChannelName();
        if (channelName == null) {
            channelUri = component.getUri().toString().startsWith("fabric3://runtime") ? Names.RUNTIME_MONITOR_CHANNEL_URI : Names.APPLICATION_MONITOR_CHANNEL_URI;
        } else {
            URI compositeUri = ((LogicalCompositeComponent)component.getParent()).getUri();
            channelUri = URI.create(compositeUri.toString() + "/" + channelName);
        }
        MonitorTargetDefinition definition = new MonitorTargetDefinition(type, monitorable, channelUri);
        definition.setOptimizable(true);
        return definition;
    }
}

