/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.model.type.component.ResourceReferenceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.monitor.model.MonitorResourceReference;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorProcessor
extends AbstractAnnotationProcessor<Monitor> {
    private final IntrospectionHelper helper;
    private final JavaContractProcessor contractProcessor;

    public MonitorProcessor(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor) {
        super(Monitor.class);
        this.helper = helper;
        this.contractProcessor = contractProcessor;
    }

    public void visitField(Monitor annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(field, null);
        Type genericType = field.getGenericType();
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        FieldInjectionSite site = new FieldInjectionSite(field);
        MonitorResourceReference resource = this.createDefinition(name, annotation, type, context);
        componentType.add((ResourceReferenceDefinition)resource, (InjectionSite)site);
    }

    public void visitMethod(Monitor annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(method, null);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Type genericType = this.helper.getGenericType(method);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        MonitorResourceReference resource = this.createDefinition(name, annotation, type, context);
        componentType.add((ResourceReferenceDefinition)resource, (InjectionSite)site);
    }

    public void visitConstructorParameter(Monitor annotation, Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, null);
        Type genericType = this.helper.getGenericType(constructor, index);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        MonitorResourceReference resource = this.createDefinition(name, annotation, type, context);
        componentType.add((ResourceReferenceDefinition)resource, (InjectionSite)site);
    }

    private MonitorResourceReference createDefinition(String name, Monitor annotation, Class<?> type, IntrospectionContext context) {
        JavaServiceContract contract = this.contractProcessor.introspect(type, context);
        String channelName = annotation.value();
        if (channelName.length() == 0) {
            return new MonitorResourceReference(name, (ServiceContract)contract);
        }
        return new MonitorResourceReference(name, (ServiceContract)contract, channelName);
    }
}

