/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fabric3.api.MonitorChannel;
import org.fabric3.host.monitor.MonitorCreationException;
import org.fabric3.host.monitor.MonitorProxyService;
import org.fabric3.host.monitor.Monitorable;
import org.fabric3.monitor.runtime.ChannelNotFoundException;
import org.fabric3.monitor.runtime.DispatchInfo;
import org.fabric3.monitor.runtime.MonitorHandler;
import org.fabric3.monitor.runtime.MonitorUtil;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.PassThroughHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKMonitorProxyService
implements MonitorProxyService {
    private String runtimeName;
    private ChannelManager channelManager;
    private Monitorable defaultMonitorable;

    public JDKMonitorProxyService(String runtimeName, Monitorable monitorable, ChannelManager channelManager) {
        this.runtimeName = runtimeName;
        this.defaultMonitorable = monitorable;
        this.channelManager = channelManager;
    }

    public <T> T createMonitor(Class<T> type, URI channelUri) throws MonitorCreationException {
        return this.createMonitor(type, this.defaultMonitorable, channelUri);
    }

    public <T> T createMonitor(Class<T> type, Monitorable monitorable, URI channelUri) throws MonitorCreationException {
        Channel channel = this.channelManager.getChannel(channelUri);
        if (channel == null) {
            throw new ChannelNotFoundException("Channel not found");
        }
        PassThroughHandler streamHandler = new PassThroughHandler();
        channel.attach((EventStreamHandler)streamHandler);
        ClassLoader loader = type.getClassLoader();
        HashMap<String, DispatchInfo> levels = new HashMap<String, DispatchInfo>();
        for (Method method : type.getMethods()) {
            DispatchInfo info = this.createDispatchInfo(type, loader, method);
            levels.put(method.getName(), info);
        }
        MonitorHandler handler = new MonitorHandler(this.runtimeName, monitorable, (EventStreamHandler)streamHandler, levels);
        if (MonitorChannel.class.equals(type)) {
            return type.cast(handler);
        }
        return type.cast(Proxy.newProxyInstance(loader, new Class[]{type}, (InvocationHandler)handler));
    }

    private <T> DispatchInfo createDispatchInfo(Class<T> type, ClassLoader loader, Method method) {
        DispatchInfo info = MonitorUtil.getDispatchInfo(method);
        String message = info.getMessage();
        if (Locale.ENGLISH.getLanguage().equals(Locale.getDefault().getLanguage())) {
            if (message.length() > 0) {
                return info;
            }
            if (message.length() == 0) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length == 1 && String.class.equals(types[0])) {
                    info.setMessage("{0}");
                    return info;
                }
                if (types.length == 2 && String.class.equals(types[0]) && Throwable.class.isAssignableFrom(types[1])) {
                    info.setMessage("{0}");
                    return info;
                }
            }
        }
        String key = type.getName() + "#" + method.getName();
        ResourceBundle bundle = this.locateBundle(type, "f3", loader);
        if (bundle != null) {
            try {
                message = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (message.length() == 0 && method.getParameterTypes().length == 0) {
            message = key;
        }
        info.setMessage(message);
        return info;
    }

    private <T> ResourceBundle locateBundle(Class<T> monitorInterface, String bundleName, ClassLoader loader) {
        Locale locale = Locale.getDefault();
        String packageName = monitorInterface.getPackage().getName();
        while (true) {
            try {
                return ResourceBundle.getBundle(packageName + '.' + bundleName, locale, loader);
            }
            catch (MissingResourceException e) {
                int index = packageName.lastIndexOf(46);
                if (index != -1) {
                    packageName = packageName.substring(0, index);
                    continue;
                }
                try {
                    return ResourceBundle.getBundle(bundleName, locale, loader);
                }
                catch (Exception e2) {
                    return null;
                }
            }
            break;
        }
    }
}

