/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.host.Names;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.monitor.runtime.LevelConverter;
import org.fabric3.spi.builder.component.ComponentBuilderListener;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.model.physical.PhysicalComponentDefinition;
import org.fabric3.spi.monitor.MonitorService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@EagerInit
@Management(name="MonitorService", path="/runtime/monitor", description="Sets monitoring levels for the runtime")
@Service(names={MonitorService.class, ComponentBuilderListener.class})
public class LogBackMonitorService
implements MonitorService,
ComponentBuilderListener {
    private ComponentManager manager;
    private HostInfo info;
    private MonitorLevel defaultLevel = MonitorLevel.WARNING;
    private Map<URI, MonitorLevel> applicationComponentLevels = Collections.emptyMap();
    private Map<URI, MonitorLevel> runtimeComponentLevels = Collections.emptyMap();
    private Map<QName, MonitorLevel> deployableLevels = Collections.emptyMap();
    private Map<String, String> providerLevels = Collections.emptyMap();

    public LogBackMonitorService(@Reference ComponentManager manager, @Reference HostInfo info) {
        this.manager = manager;
        this.info = info;
    }

    @Property(required=false)
    public void setDefaultLevel(String defaultLevel) {
        this.defaultLevel = MonitorLevel.valueOf((String)defaultLevel);
    }

    @Property(required=false)
    public void setApplicationComponentLevels(Element levels) {
        this.applicationComponentLevels = new HashMap<URI, MonitorLevel>();
        String base = this.info.getDomain().toString();
        NodeList list = levels.getElementsByTagName("level");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String name = element.getAttribute("name");
            URI uri = name.length() == 0 ? this.info.getDomain() : URI.create(base + "/" + name);
            String value = element.getAttribute("value").toUpperCase();
            MonitorLevel level = MonitorLevel.valueOf((String)value);
            this.applicationComponentLevels.put(uri, level);
        }
    }

    @Property(required=false)
    public void setRuntimeComponentLevels(Element levels) {
        this.runtimeComponentLevels = new HashMap<URI, MonitorLevel>();
        NodeList list = levels.getElementsByTagName("level");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String name = element.getAttribute("name");
            URI uri = name.length() == 0 ? Names.RUNTIME_URI : URI.create("fabric3://runtime/" + name);
            String value = element.getAttribute("value").toUpperCase();
            MonitorLevel level = MonitorLevel.valueOf((String)value);
            this.runtimeComponentLevels.put(uri, level);
        }
    }

    @Property(required=false)
    public void setDeployableLevels(Element levels) {
        this.deployableLevels = new HashMap<QName, MonitorLevel>();
        NodeList list = levels.getElementsByTagName("level");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String value = element.getAttribute("value").toUpperCase();
            MonitorLevel level = MonitorLevel.valueOf((String)value.toUpperCase());
            this.deployableLevels.put(this.getQualifiedName(element), level);
        }
    }

    @Property(required=false)
    public void setLoggerLevels(Element levels) {
        this.providerLevels = new HashMap<String, String>();
        NodeList list = levels.getElementsByTagName("level");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String className = element.getAttribute("name");
            String level = element.getAttribute("value");
            this.setProviderLevel(className, level);
        }
    }

    @Init
    public void init() {
        Level level = LevelConverter.getLogbackLevel(this.defaultLevel);
        ((Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(level);
        for (Map.Entry<QName, MonitorLevel> entry : this.deployableLevels.entrySet()) {
            for (Component component : this.manager.getDeployedComponents(entry.getKey())) {
                component.setLevel(entry.getValue());
            }
        }
        for (Map.Entry<Serializable, MonitorLevel> entry : this.applicationComponentLevels.entrySet()) {
            for (Component component : this.manager.getComponentsInHierarchy((URI)entry.getKey())) {
                component.setLevel(entry.getValue());
            }
        }
        for (Map.Entry<Serializable, MonitorLevel> entry : this.runtimeComponentLevels.entrySet()) {
            for (Component component : this.manager.getComponentsInHierarchy((URI)entry.getKey())) {
                component.setLevel(entry.getValue());
            }
        }
    }

    @ManagementOperation(description="Sets the monitoring level for a component")
    public void setComponentLevel(String uri, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level);
        List components = this.manager.getComponentsInHierarchy(URI.create(uri));
        for (Component component : components) {
            component.setLevel(parsed);
        }
    }

    @ManagementOperation(description="Sets the monitoring level for a deployable composite")
    public void setDeployableLevel(String deployable, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level);
        List components = this.manager.getDeployedComponents(QName.valueOf(deployable));
        for (Component component : components) {
            component.setLevel(parsed);
        }
    }

    @ManagementOperation(description="Sets the monitoring level for a provider")
    public void setProviderLevel(String key, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level);
        Level logBackLevel = LevelConverter.getLogbackLevel(parsed);
        ((Logger)LoggerFactory.getLogger((String)key)).setLevel(logBackLevel);
    }

    public void onBuild(Component component, PhysicalComponentDefinition definition) {
        String strUri = component.getUri().toString();
        for (Map.Entry<URI, MonitorLevel> entry : this.runtimeComponentLevels.entrySet()) {
            if (!strUri.startsWith(entry.getKey().toString())) continue;
            component.setLevel(entry.getValue());
            return;
        }
        for (Map.Entry<URI, MonitorLevel> entry : this.applicationComponentLevels.entrySet()) {
            if (!strUri.startsWith(entry.getKey().toString())) continue;
            component.setLevel(entry.getValue());
            return;
        }
        MonitorLevel level = this.deployableLevels.get(component.getDeployable());
        if (level != null) {
            component.setLevel(level);
        }
    }

    public void onDispose(Component component, PhysicalComponentDefinition definition) {
    }

    private QName getQualifiedName(Element element) {
        String text = element.getAttribute("name");
        int index = text.indexOf(58);
        if (index < 1 || index == text.length() - 1) {
            return new QName(null, text);
        }
        String prefix = text.substring(0, index);
        String uri = element.lookupNamespaceURI(prefix);
        String localPart = text.substring(index + 1);
        return new QName(uri, localPart, prefix);
    }
}

