/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fabric3.api.MonitorEvent;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LogbackDispatcher
implements MonitorEventDispatcher {
    private static final String DEFAULT_PATTERN = "[%level %thread %d{YY:MM:DD HH:mm:ss.SSS}] %msg%n%ex";
    private boolean additive;
    private boolean configured;
    private LoggerContext context;
    private Logger logger;
    private File logDirectory;

    public LogbackDispatcher(String name, File logDirectory) {
        this(name, false, logDirectory);
    }

    public LogbackDispatcher(String name, boolean additive, File logDirectory) {
        this.additive = additive;
        this.logDirectory = logDirectory;
        this.context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.logger = this.context.getLogger(name);
        this.logger.setAdditive(additive);
    }

    public void configure(Element element) throws MonitorConfigurationException {
        try {
            this.expandLogFileNames(element);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.adoptNode(element);
            document.appendChild(element);
            InputSource source = this.transform(document);
            this.logger.detachAndStopAllAppenders();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)this.context);
            configurator.doConfigure(source);
            this.logger.setAdditive(this.additive);
            this.configured = true;
        }
        catch (ParserConfigurationException e) {
            throw new MonitorConfigurationException("Error parsing monitor configuration", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new MonitorConfigurationException("Error parsing monitor configuration", (Throwable)e);
        }
        catch (JoranException e) {
            throw new MonitorConfigurationException("Error parsing monitor configuration", (Throwable)e);
        }
    }

    public void start() {
        if (!this.configured) {
            this.configureDefaultAppender(this.context);
        }
        this.checkLogErrors();
    }

    public void stop() {
        this.logger.detachAndStopAllAppenders();
    }

    public void onEvent(MonitorEvent event) {
        if (!(event instanceof ILoggingEvent)) {
            throw new AssertionError((Object)("Event must implement " + ILoggingEvent.class.getName()));
        }
        this.logger.callAppenders((ILoggingEvent)event);
    }

    private void expandLogFileNames(Element element) {
        NodeList files = element.getElementsByTagName("file");
        File dir = new File(this.logDirectory, "log");
        for (int i = 0; i < files.getLength(); ++i) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Element fileElement = (Element)files.item(i);
            fileElement.setTextContent(new File(dir, fileElement.getTextContent()).getAbsolutePath());
        }
    }

    private void configureDefaultAppender(LoggerContext context) {
        this.logger.detachAndStopAllAppenders();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)context);
        appender.setName("fabric3-console");
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern(DEFAULT_PATTERN);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.start();
        this.logger.addAppender((Appender)appender);
    }

    private InputSource transform(Document document) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(stream);
        transformer.transform(source, result);
        return new InputSource(new ByteArrayInputStream(stream.toByteArray()));
    }

    private void checkLogErrors() {
        LoggerContext context = this.logger.getLoggerContext();
        StatusManager sm = context.getStatusManager();
        long currentTimeMillis = System.currentTimeMillis();
        StatusChecker sc = new StatusChecker((Context)context);
        if (sm != null && !sc.isErrorFree(currentTimeMillis)) {
            List list = sm.getCopyOfStatusList();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            String time = format.format(new Date(currentTimeMillis));
            for (Status status : list) {
                if (status.getLevel() != 2) continue;
                System.err.println("[ERROR " + Thread.currentThread().getName() + " " + time + "] " + status.getMessage());
                Throwable throwable = status.getThrowable();
                if (throwable == null) continue;
                throwable.printStackTrace();
            }
        }
    }

    static {
        ((LoggerContext)LoggerFactory.getILoggerFactory()).getLogger("ROOT").detachAndStopAllAppenders();
    }
}

