/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.fabric3.host.monitor.MonitorEventDispatcherFactory;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.monitor.provision.MonitorComponentDefinition;
import org.fabric3.monitor.runtime.MonitorComponent;
import org.fabric3.monitor.runtime.MonitorComponentBuildException;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.component.ComponentBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class MonitorComponentBuilder
implements ComponentBuilder<MonitorComponentDefinition, MonitorComponent> {
    private MonitorEventDispatcherFactory factory;
    private HostInfo hostInfo;

    public MonitorComponentBuilder(@Reference MonitorEventDispatcherFactory factory, @Reference HostInfo hostInfo) {
        this.factory = factory;
        this.hostInfo = hostInfo;
    }

    public MonitorComponent build(MonitorComponentDefinition definition) throws BuilderException {
        URI uri = definition.getComponentUri();
        QName deployable = definition.getDeployable();
        Element configuration = definition.getConfiguration();
        if (configuration != null) {
            this.addAppenderReferences(configuration.getOwnerDocument(), uri.toString(), configuration);
        }
        try {
            MonitorEventDispatcher dispatcher = this.factory.createInstance(uri.toString(), configuration, this.hostInfo.getDataDir());
            return new MonitorComponent(uri, deployable, dispatcher);
        }
        catch (MonitorConfigurationException e) {
            throw new MonitorComponentBuildException(e);
        }
    }

    public void dispose(MonitorComponentDefinition definition, MonitorComponent component) throws BuilderException {
    }

    private void addAppenderReferences(Document document, String loggerName, Element element) {
        NodeList elements = element.getElementsByTagName("appender");
        ArrayList<Element> added = new ArrayList<Element>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            Node nameAttribute = node.getAttributes().getNamedItem("name");
            if (nameAttribute == null) continue;
            String name = nameAttribute.getNodeValue();
            Element reference = document.createElement("appender-ref");
            reference.setAttribute("ref", name);
            added.add(reference);
        }
        if (!added.isEmpty()) {
            Element root = document.createElement("logger");
            root.setAttribute("name", loggerName);
            element.appendChild(root);
            for (Element reference : added) {
                root.appendChild(reference);
            }
        }
    }
}

