/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import org.fabric3.api.MonitorChannel;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.host.monitor.Monitorable;
import org.fabric3.monitor.runtime.DispatchInfo;
import org.fabric3.monitor.runtime.MonitorEventImpl;
import org.fabric3.spi.channel.EventStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorHandler
implements InvocationHandler,
MonitorChannel {
    private static final Object[] EMPTY_DATA = new Object[0];
    private Monitorable monitorable;
    private String runtimeName;
    private String source;
    private EventStreamHandler streamHandler;
    private MonitorLevel level;
    private String message;
    private Map<String, DispatchInfo> infos;

    public MonitorHandler(String runtimeName, Monitorable monitorable, EventStreamHandler streamHandler, Map<String, DispatchInfo> infos) {
        this.runtimeName = runtimeName;
        this.monitorable = monitorable;
        this.source = monitorable.getName();
        this.streamHandler = streamHandler;
        this.infos = infos;
        if (infos.size() == 1) {
            DispatchInfo info = infos.values().iterator().next();
            this.level = info.getLevel();
            this.message = info.getMessage();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String currentMessage;
        MonitorLevel currentLevel;
        if (this.level != null) {
            currentLevel = this.level;
            currentMessage = this.message;
        } else {
            DispatchInfo info = this.infos.get(method.getName());
            currentLevel = info.getLevel();
            currentMessage = info.getMessage();
        }
        if (currentLevel == null || currentLevel.intValue() < this.monitorable.getLevel().intValue()) {
            return null;
        }
        this.dispatch(currentLevel, currentMessage, args);
        return null;
    }

    public void severe(String message, Object ... args) {
        if (this.off(MonitorLevel.SEVERE)) {
            return;
        }
        this.dispatch(MonitorLevel.SEVERE, message, args);
    }

    public void warn(String message, Object ... args) {
        if (this.off(MonitorLevel.WARNING)) {
            return;
        }
        this.dispatch(MonitorLevel.WARNING, message, args);
    }

    public void info(String message, Object ... args) {
        if (this.off(MonitorLevel.INFO)) {
            return;
        }
        this.dispatch(MonitorLevel.INFO, message, args);
    }

    public void debug(String message, Object ... args) {
        if (this.off(MonitorLevel.DEBUG)) {
            return;
        }
        this.dispatch(MonitorLevel.DEBUG, message, args);
    }

    public void trace(String message, Object ... args) {
        if (this.off(MonitorLevel.TRACE)) {
            return;
        }
        this.dispatch(MonitorLevel.TRACE, message, args);
    }

    private String format(String message, Object[] args) {
        if (message == null) {
            StringBuilder builder = new StringBuilder();
            for (Object arg : args) {
                builder.append(arg).append(" ");
            }
            return builder.toString();
        }
        if (args != null && args.length != 0 && (message.indexOf("{0") >= 0 || message.indexOf("{1") >= 0 || message.indexOf("{2") >= 0 || message.indexOf("{3") >= 0)) {
            return MessageFormat.format(message, args);
        }
        return message;
    }

    private boolean off(MonitorLevel currentLevel) {
        return currentLevel.intValue() < this.monitorable.getLevel().intValue();
    }

    private void dispatch(MonitorLevel currentLevel, String message, Object[] args) {
        String thread = Thread.currentThread().getName();
        message = this.format(message, args);
        long time = System.currentTimeMillis();
        if (args == null) {
            args = EMPTY_DATA;
        }
        MonitorEventImpl event = new MonitorEventImpl(this.runtimeName, this.source, currentLevel, time, thread, message, args);
        Object[] param = new Object[]{event};
        this.streamHandler.handle((Object)param);
    }
}

