/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fabric3.api.annotation.monitor.MonitorEventType;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.monitor.runtime.DispatchInfo;

public class MonitorUtil {
    public static DispatchInfo getDispatchInfo(Method method) {
        MonitorLevel level = null;
        String message = "";
        MonitorEventType annotation = method.getAnnotation(MonitorEventType.class);
        if (annotation != null) {
            level = annotation.value();
        }
        if (level == null) {
            for (Annotation methodAnnotation : method.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
                MonitorEventType monitorEventType = annotationType.getAnnotation(MonitorEventType.class);
                if (monitorEventType == null) continue;
                level = monitorEventType.value();
                try {
                    Method valueMethod = methodAnnotation.getClass().getMethod("value", new Class[0]);
                    message = (String)valueMethod.invoke((Object)methodAnnotation, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    throw new AssertionError((Object)e);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                return new DispatchInfo(level, message);
            }
        }
        return new DispatchInfo(MonitorLevel.DEBUG, "");
    }
}

