/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.artifact;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.util.FileHelper;
import org.fabric3.spi.artifact.ArtifactCache;
import org.fabric3.spi.artifact.CacheException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FSArtifactCache
implements ArtifactCache {
    private File tempDir;
    private Map<URI, Entry> entries;

    public FSArtifactCache(@Reference HostInfo info) {
        this.tempDir = new File(info.getTempDir(), "cache");
        this.entries = new HashMap<URI, Entry>();
    }

    @Init
    public void init() throws IOException {
        if (this.tempDir.exists()) {
            FileHelper.deleteDirectory((File)this.tempDir);
        }
        this.tempDir.mkdirs();
    }

    public synchronized URL cache(URI uri, InputStream stream) throws CacheException {
        if (this.entries.containsKey(uri)) {
            throw new CacheException("Entry for URI already exists: " + uri);
        }
        try {
            String suffix = this.getSuffix(uri);
            File file = File.createTempFile("fabric3-", suffix, this.tempDir);
            FileHelper.write((InputStream)stream, (File)file);
            URL url = file.toURI().toURL();
            Entry entry = new Entry(url, file);
            this.entries.put(uri, entry);
            file.deleteOnExit();
            URL uRL = url;
            return uRL;
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized URL get(URI uri) {
        Entry entry = this.entries.get(uri);
        if (entry == null) {
            return null;
        }
        return entry.getEntryURL();
    }

    public synchronized boolean remove(URI uri) {
        Entry entry = this.entries.get(uri);
        if (entry == null) {
            return false;
        }
        entry.getFile().delete();
        this.entries.remove(uri);
        return true;
    }

    private String getSuffix(URI uri) {
        String suffix = null;
        String strUri = uri.toString();
        int pos = strUri.lastIndexOf(".");
        if (pos >= 0) {
            suffix = strUri.substring(pos);
        }
        if (suffix == null) {
            return null;
        }
        return suffix.replace("/", "_");
    }

    private class Entry {
        private URL entryURL;
        private File file;

        private Entry(URL entryURL, File file) {
            this.entryURL = entryURL;
            this.file = file;
        }

        public URL getEntryURL() {
            return this.entryURL;
        }

        public File getFile() {
            return this.file;
        }
    }
}

