/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.binding;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.spi.binding.handler.BindingHandler;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.ScopedComponent;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.WorkContextTunnel;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingHandlerLazyLoadDecorator<T>
implements BindingHandler<T> {
    private URI handlerUri;
    private ComponentManager componentManager;
    private volatile ScopedComponent delegate;

    public BindingHandlerLazyLoadDecorator(URI handlerUri, ComponentManager componentManager) {
        this.handlerUri = handlerUri;
        this.componentManager = componentManager;
    }

    public QName getType() {
        return this.inject().getType();
    }

    public void handleOutbound(Message message, T context) {
        this.inject().handleOutbound(message, context);
    }

    public void handleInbound(T context, Message message) {
        this.inject().handleInbound(context, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BindingHandler<T> inject() {
        if (this.delegate == null) {
            BindingHandlerLazyLoadDecorator bindingHandlerLazyLoadDecorator = this;
            synchronized (bindingHandlerLazyLoadDecorator) {
                if (this.delegate == null) {
                    Component component = this.componentManager.getComponent(this.handlerUri);
                    if (component == null) {
                        throw new ServiceUnavailableException("Handler component not found: " + this.handlerUri);
                    }
                    if (!(component instanceof ScopedComponent)) {
                        throw new ServiceRuntimeException("Handler component must be a scoped component type: " + this.handlerUri);
                    }
                    this.delegate = (ScopedComponent)component;
                }
            }
        }
        try {
            return (BindingHandler)this.delegate.getInstance(WorkContextTunnel.getThreadWorkContext());
        }
        catch (InstanceLifecycleException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

