/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.binding;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.binding.BindingSelector;
import org.fabric3.fabric.binding.NoSCABindingProviderException;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.binding.provider.BindingMatchResult;
import org.fabric3.spi.binding.provider.BindingProvider;
import org.fabric3.spi.binding.provider.BindingSelectionException;
import org.fabric3.spi.binding.provider.BindingSelectionStrategy;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BindingSelectorImpl
implements BindingSelector {
    private boolean disable;
    private HostInfo info;
    private BindingSelectionStrategy strategy;
    private List<BindingProvider> providers = new ArrayList<BindingProvider>();

    public BindingSelectorImpl(@Reference HostInfo info) {
        this.info = info;
    }

    @Property(required=false)
    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    @Reference(required=false)
    public void setProviders(List<BindingProvider> providers) {
        this.providers = providers;
        this.orderProviders();
    }

    @Reference(required=false)
    public void setStrategy(BindingSelectionStrategy strategy) {
        this.strategy = strategy;
    }

    @Init
    public void orderProviders() {
        if (this.strategy != null) {
            this.strategy.order(this.providers);
        }
    }

    @Override
    public void selectBindings(LogicalCompositeComponent domain) throws BindingSelectionException {
        if (RuntimeMode.CONTROLLER != this.info.getRuntimeMode() || this.disable) {
            return;
        }
        Collection components = domain.getComponents();
        for (LogicalComponent component : components) {
            if (component.getState() != LogicalState.NEW) continue;
            this.selectBindings(component);
        }
        for (LogicalChannel channel : domain.getChannels()) {
            this.selectBinding(channel);
        }
    }

    private void selectBindings(LogicalComponent<?> component) throws BindingSelectionException {
        for (LogicalReference reference : component.getReferences()) {
            for (LogicalWire wire : reference.getWires()) {
                LogicalService targetService = wire.getTarget();
                if (targetService == null) continue;
                LogicalComponent targetComponent = (LogicalComponent)targetService.getParent();
                if ("LocalZone".equals(component.getZone()) && "LocalZone".equals(targetComponent.getZone()) || !"LocalZone".equals(component.getZone()) && component.getZone().equals(targetComponent.getZone())) continue;
                this.selectBinding(wire);
            }
        }
    }

    private void selectBinding(LogicalWire wire) throws BindingSelectionException {
        ArrayList<BindingMatchResult> results = new ArrayList<BindingMatchResult>();
        LogicalReference source = wire.getSource();
        LogicalService target = wire.getTarget();
        for (BindingProvider provider : this.providers) {
            BindingMatchResult result = provider.canBind(wire);
            if (result.isMatch()) {
                source.getBindings().clear();
                target.getBindings().clear();
                provider.bind(wire);
                if (source.getLeafReference().getBindings().isEmpty()) {
                    QName type = result.getType();
                    throw new BindingSelectionException("Binding provider error. Provider did not set a binding for the reference: " + type);
                }
                if (target.getLeafService().getBindings().isEmpty()) {
                    QName type = result.getType();
                    throw new BindingSelectionException("Binding provider error. Provider did not set a binding for the service: " + type);
                }
                wire.setSourceBinding((LogicalBinding)source.getBindings().get(0));
                if (!target.getBindings().isEmpty()) {
                    wire.setTargetBinding((LogicalBinding)target.getBindings().get(0));
                } else {
                    wire.setTargetBinding((LogicalBinding)target.getLeafService().getBindings().get(0));
                }
                return;
            }
            results.add(result);
        }
        URI sourceUri = source.getUri();
        URI targetUri = target.getUri();
        throw new NoSCABindingProviderException("No SCA binding provider suitable for creating wire from " + sourceUri + " to " + targetUri, results);
    }

    private void selectBinding(LogicalChannel channel) throws BindingSelectionException {
        if (channel.isConcreteBound()) {
            return;
        }
        ArrayList<BindingMatchResult> results = new ArrayList<BindingMatchResult>();
        for (BindingProvider provider : this.providers) {
            BindingMatchResult result = provider.canBind(channel);
            if (result.isMatch()) {
                channel.clearBinding();
                provider.bind(channel);
                if (channel.getBindings().isEmpty()) {
                    QName type = result.getType();
                    throw new BindingSelectionException("Binding provider error. Provider did not set a binding for the channel: " + type);
                }
                return;
            }
            results.add(result);
        }
        URI uri = channel.getUri();
        throw new NoSCABindingProviderException("No SCA binding provider suitable for channel " + uri, results);
    }
}

