/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.binding;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.spi.binding.provider.BindingProvider;
import org.fabric3.spi.binding.provider.BindingSelectionStrategy;
import org.oasisopen.sca.annotation.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableBindingSelectionStrategy
implements BindingSelectionStrategy {
    private Map<QName, Integer> bindingOrder;
    private BindingProviderComparator comparator = new BindingProviderComparator();

    @Property(required=false)
    public void setScaBindingOrder(List<QName> order) {
        this.bindingOrder = new HashMap<QName, Integer>(order.size());
        for (int i = 0; i < order.size(); ++i) {
            QName name = order.get(i);
            this.bindingOrder.put(name, i);
        }
    }

    public void order(List<BindingProvider> providers) {
        if (this.bindingOrder == null || providers.isEmpty()) {
            return;
        }
        Collections.sort(providers, this.comparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BindingProviderComparator
    implements Comparator<BindingProvider> {
        private BindingProviderComparator() {
        }

        @Override
        public int compare(BindingProvider one, BindingProvider two) {
            Integer posTwo;
            Integer posOne = (Integer)ConfigurableBindingSelectionStrategy.this.bindingOrder.get(one.getType());
            if (posOne == null) {
                posOne = -1;
            }
            if ((posTwo = (Integer)ConfigurableBindingSelectionStrategy.this.bindingOrder.get(two.getType())) == null) {
                posTwo = -1;
            }
            return posOne - posTwo;
        }
    }
}

