/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder;

import java.util.List;
import java.util.Map;
import org.fabric3.fabric.builder.AttacherNotFoundException;
import org.fabric3.fabric.builder.ChannelConnector;
import org.fabric3.fabric.channel.ChannelConnectionImpl;
import org.fabric3.fabric.channel.EventStreamImpl;
import org.fabric3.fabric.channel.FilterHandler;
import org.fabric3.fabric.channel.TransformerHandler;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.channel.EventFilter;
import org.fabric3.spi.builder.channel.EventFilterBuilder;
import org.fabric3.spi.builder.channel.EventStreamHandlerBuilder;
import org.fabric3.spi.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalEventFilterDefinition;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.fabric3.spi.model.physical.PhysicalHandlerDefinition;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelConnectorImpl
implements ChannelConnector {
    private Map<Class<? extends PhysicalConnectionSourceDefinition>, SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition>> sourceAttachers;
    private Map<Class<? extends PhysicalConnectionTargetDefinition>, TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition>> targetAttachers;
    private Map<Class<? extends PhysicalEventFilterDefinition>, EventFilterBuilder<? extends PhysicalEventFilterDefinition>> filterBuilders;
    private Map<Class<? extends PhysicalHandlerDefinition>, EventStreamHandlerBuilder<? extends PhysicalHandlerDefinition>> handlerBuilders;
    private ClassLoaderRegistry classLoaderRegistry;
    private TransformerRegistry transformerRegistry;

    @Reference
    public void setClassLoaderRegistry(ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Reference
    public void setTransformerRegistry(TransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    @Reference(required=false)
    public void setSourceAttachers(Map<Class<? extends PhysicalConnectionSourceDefinition>, SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition>> sourceAttachers) {
        this.sourceAttachers = sourceAttachers;
    }

    @Reference(required=false)
    public void setTargetAttachers(Map<Class<? extends PhysicalConnectionTargetDefinition>, TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition>> targetAttachers) {
        this.targetAttachers = targetAttachers;
    }

    @Reference(required=false)
    public void setFilterBuilders(Map<Class<? extends PhysicalEventFilterDefinition>, EventFilterBuilder<? extends PhysicalEventFilterDefinition>> filterBuilders) {
        this.filterBuilders = filterBuilders;
    }

    @Reference(required=false)
    public void setHandlerBuilders(Map<Class<? extends PhysicalHandlerDefinition>, EventStreamHandlerBuilder<? extends PhysicalHandlerDefinition>> handlerBuilders) {
        this.handlerBuilders = handlerBuilders;
    }

    @Override
    public void connect(PhysicalChannelConnectionDefinition definition) throws BuilderException {
        PhysicalConnectionSourceDefinition source = definition.getSource();
        PhysicalConnectionTargetDefinition target = definition.getTarget();
        SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + target.getClass().getName());
        }
        ChannelConnection connection = this.createConnection(definition);
        sourceAttacher.attach(source, target, connection);
        targetAttacher.attach(source, target, connection);
    }

    @Override
    public void disconnect(PhysicalChannelConnectionDefinition definition) throws BuilderException {
        PhysicalConnectionSourceDefinition source = definition.getSource();
        PhysicalConnectionTargetDefinition target = definition.getTarget();
        SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + target.getClass().getName());
        }
        sourceAttacher.detach(source, target);
        targetAttacher.detach(source, target);
    }

    private ChannelConnection createConnection(PhysicalChannelConnectionDefinition definition) throws BuilderException {
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(definition.getTarget().getClassLoaderId());
        ChannelConnectionImpl connection = new ChannelConnectionImpl();
        for (PhysicalEventStreamDefinition streamDefinition : definition.getEventStreams()) {
            EventStreamImpl stream = new EventStreamImpl(streamDefinition);
            this.addTransformer(streamDefinition, stream, loader);
            this.addFilters(streamDefinition, stream);
            this.addHandlers(streamDefinition, stream);
            connection.addEventStream(stream);
        }
        return connection;
    }

    private void addTransformer(PhysicalEventStreamDefinition streamDefinition, EventStream stream, ClassLoader loader) throws BuilderException {
        if (this.transformerRegistry == null) {
            return;
        }
        List eventTypes = streamDefinition.getEventTypes();
        String stringifiedType = (String)eventTypes.get(0);
        try {
            JavaClass type = new JavaClass(loader.loadClass(stringifiedType));
            TransformerHandler handler = new TransformerHandler((DataType<Object>)type, this.transformerRegistry);
            stream.addHandler((EventStreamHandler)handler);
        }
        catch (ClassNotFoundException e) {
            throw new BuilderException((Throwable)e);
        }
    }

    private void addFilters(PhysicalEventStreamDefinition streamDefinition, EventStream stream) throws BuilderException {
        for (PhysicalEventFilterDefinition definition : streamDefinition.getFilters()) {
            EventFilterBuilder<? extends PhysicalEventFilterDefinition> builder = this.filterBuilders.get(definition.getClass());
            EventFilter filter = builder.build(definition);
            FilterHandler handler = new FilterHandler(filter);
            stream.addHandler((EventStreamHandler)handler);
        }
    }

    private void addHandlers(PhysicalEventStreamDefinition streamDefinition, EventStream stream) throws BuilderException {
        for (PhysicalHandlerDefinition definition : streamDefinition.getHandlers()) {
            EventStreamHandlerBuilder<? extends PhysicalHandlerDefinition> builder = this.handlerBuilders.get(definition.getClass());
            EventStreamHandler handler = builder.build(definition);
            stream.addHandler(handler);
        }
    }
}

