/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.fabric3.fabric.builder.AttacherNotFoundException;
import org.fabric3.fabric.builder.Connector;
import org.fabric3.fabric.builder.transform.TransformerInterceptorFactory;
import org.fabric3.fabric.wire.InvocationChainImpl;
import org.fabric3.fabric.wire.WireImpl;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.builder.interceptor.InterceptorBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalInterceptorDefinition;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorImpl
implements Connector {
    private Map<Class<? extends PhysicalInterceptorDefinition>, InterceptorBuilder<?>> interceptorBuilders;
    private Map<Class<? extends PhysicalSourceDefinition>, SourceWireAttacher<? extends PhysicalSourceDefinition>> sourceAttachers;
    private Map<Class<? extends PhysicalTargetDefinition>, TargetWireAttacher<? extends PhysicalTargetDefinition>> targetAttachers;
    private ClassLoaderRegistry classLoaderRegistry;
    private TransformerInterceptorFactory transformerFactory;
    private boolean transform;

    public ConnectorImpl() {
    }

    @Constructor
    public ConnectorImpl(@Reference ClassLoaderRegistry classLoaderRegistry, @Reference TransformerInterceptorFactory transformerFactory) {
        this.classLoaderRegistry = classLoaderRegistry;
        this.transformerFactory = transformerFactory;
        this.transform = true;
    }

    @Reference
    public void setInterceptorBuilders(Map<Class<? extends PhysicalInterceptorDefinition>, InterceptorBuilder<?>> interceptorBuilders) {
        this.interceptorBuilders = interceptorBuilders;
    }

    @Reference(required=false)
    public void setSourceAttachers(Map<Class<? extends PhysicalSourceDefinition>, SourceWireAttacher<? extends PhysicalSourceDefinition>> sourceAttachers) {
        this.sourceAttachers = sourceAttachers;
    }

    @Reference
    public void setTargetAttachers(Map<Class<? extends PhysicalTargetDefinition>, TargetWireAttacher<? extends PhysicalTargetDefinition>> targetAttachers) {
        this.targetAttachers = targetAttachers;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    @Override
    public void connect(PhysicalWireDefinition definition) throws BuilderException {
        PhysicalSourceDefinition sourceDefinition = definition.getSource();
        SourceWireAttacher<PhysicalSourceDefinition> sourceAttacher = this.getAttacher(sourceDefinition);
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Source attacher not found for type: " + sourceDefinition.getClass());
        }
        PhysicalTargetDefinition targetDefinition = definition.getTarget();
        TargetWireAttacher<PhysicalTargetDefinition> targetAttacher = this.getAttacher(targetDefinition);
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Target attacher not found for type: " + targetDefinition.getClass());
        }
        if (definition.isOptimizable()) {
            ObjectFactory objectFactory = targetAttacher.createObjectFactory(targetDefinition);
            sourceAttacher.attachObjectFactory(sourceDefinition, objectFactory, targetDefinition);
        } else {
            Wire wire = this.createWire(definition);
            sourceAttacher.attach(sourceDefinition, targetDefinition, wire);
            targetAttacher.attach(sourceDefinition, targetDefinition, wire);
        }
    }

    @Override
    public void disconnect(PhysicalWireDefinition definition) throws BuilderException {
        PhysicalSourceDefinition sourceDefinition = definition.getSource();
        SourceWireAttacher<PhysicalSourceDefinition> sourceAttacher = this.getAttacher(sourceDefinition);
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Source attacher not found for type: " + sourceDefinition.getClass());
        }
        PhysicalTargetDefinition targetDefinition = definition.getTarget();
        if (definition.isOptimizable()) {
            sourceAttacher.detachObjectFactory(sourceDefinition, targetDefinition);
        } else {
            TargetWireAttacher<PhysicalTargetDefinition> targetAttacher = this.getAttacher(targetDefinition);
            if (targetAttacher == null) {
                throw new AttacherNotFoundException("Target attacher not found for type: " + targetDefinition.getClass());
            }
            targetAttacher.detach(sourceDefinition, targetDefinition);
            sourceAttacher.detach(sourceDefinition, targetDefinition);
        }
    }

    Wire createWire(PhysicalWireDefinition definition) throws BuilderException {
        WireImpl wire = new WireImpl();
        for (PhysicalOperationDefinition operation : definition.getOperations()) {
            InvocationChainImpl chain = new InvocationChainImpl(operation);
            for (PhysicalInterceptorDefinition interceptorDefinition : operation.getInterceptors()) {
                InterceptorBuilder<PhysicalInterceptorDefinition> builder = this.getBuilder(interceptorDefinition);
                Interceptor interceptor = builder.build(interceptorDefinition);
                chain.addInterceptor(interceptor);
            }
            wire.addInvocationChain(chain);
        }
        this.processTransform(wire, definition);
        return wire;
    }

    private void processTransform(Wire wire, PhysicalWireDefinition definition) throws WiringException {
        if (!this.transform) {
            return;
        }
        PhysicalSourceDefinition sourceDefinition = definition.getSource();
        PhysicalTargetDefinition targetDefinition = definition.getTarget();
        for (DataType sourceType : sourceDefinition.getPhysicalDataTypes()) {
            if (!targetDefinition.getPhysicalDataTypes().contains(sourceType)) continue;
            this.addTransformer(wire, definition, true);
            return;
        }
        this.addTransformer(wire, definition, false);
    }

    private void addTransformer(Wire wire, PhysicalWireDefinition definition, boolean checkPassByRef) throws WiringException {
        PhysicalSourceDefinition sourceDefinition = definition.getSource();
        PhysicalTargetDefinition targetDefinition = definition.getTarget();
        URI sourceId = sourceDefinition.getClassLoaderId();
        URI targetId = targetDefinition.getClassLoaderId();
        ClassLoader sourceLoader = null;
        ClassLoader targetLoader = null;
        for (InvocationChain chain : wire.getInvocationChains()) {
            if (checkPassByRef && chain.getPhysicalOperation().isAllowsPassByReference()) continue;
            if (sourceLoader == null && targetLoader == null) {
                sourceLoader = this.classLoaderRegistry.getClassLoader(sourceId);
                targetLoader = this.classLoaderRegistry.getClassLoader(targetId);
            }
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            List sourceTypes = sourceDefinition.getPhysicalDataTypes();
            List targetTypes = targetDefinition.getPhysicalDataTypes();
            Interceptor interceptor = this.transformerFactory.createInterceptor(operation, sourceTypes, targetTypes, targetLoader, sourceLoader);
            chain.addInterceptor(interceptor);
        }
    }

    private <PID extends PhysicalInterceptorDefinition> InterceptorBuilder<PID> getBuilder(PID definition) {
        return this.interceptorBuilders.get(definition.getClass());
    }

    private <PSD extends PhysicalSourceDefinition> SourceWireAttacher<PSD> getAttacher(PSD source) {
        return this.sourceAttachers.get(source.getClass());
    }

    private <PSD extends PhysicalTargetDefinition> TargetWireAttacher<PSD> getAttacher(PSD target) {
        return this.targetAttachers.get(target.getClass());
    }
}

