/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder.channel;

import java.net.URI;
import org.fabric3.fabric.builder.channel.ChannelNotFoundException;
import org.fabric3.fabric.model.physical.ChannelSourceDefinition;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ChannelSourceAttacher
implements SourceConnectionAttacher<ChannelSourceDefinition> {
    private ChannelManager channelManager;

    public ChannelSourceAttacher(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    public void attach(ChannelSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        URI uri = source.getUri();
        Channel channel = this.getChannel(uri);
        URI targetUri = target.getTargetUri();
        channel.subscribe(targetUri, connection);
    }

    public void detach(ChannelSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ConnectionAttachException {
        URI uri = source.getUri();
        Channel channel = this.getChannel(uri);
        URI targetUri = target.getTargetUri();
        channel.unsubscribe(targetUri);
    }

    private Channel getChannel(URI uri) throws ChannelNotFoundException {
        Channel channel = this.channelManager.getChannel(uri);
        if (channel == null) {
            throw new ChannelNotFoundException("Channel not found");
        }
        return channel;
    }
}

