/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder.channel;

import java.net.URI;
import org.fabric3.fabric.builder.channel.ChannelNotFoundException;
import org.fabric3.fabric.model.physical.ChannelTargetDefinition;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ChannelTargetAttacher
implements TargetConnectionAttacher<ChannelTargetDefinition> {
    private ChannelManager channelManager;

    public ChannelTargetAttacher(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    public void attach(PhysicalConnectionSourceDefinition source, ChannelTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        URI uri = target.getTargetUri();
        Channel channel = this.getChannel(uri);
        channel.attach(connection);
    }

    public void detach(PhysicalConnectionSourceDefinition source, ChannelTargetDefinition target) throws ConnectionAttachException {
    }

    private Channel getChannel(URI uri) throws ChannelNotFoundException {
        Channel channel = this.channelManager.getChannel(uri);
        if (channel == null) {
            throw new ChannelNotFoundException("Channel not found");
        }
        return channel;
    }
}

