/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder.classloader;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.fabric3.fabric.builder.classloader.ClassLoaderTracker;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class ClassLoaderTrackerImpl
implements ClassLoaderTracker {
    private Map<URI, AtomicInteger> counters = new ConcurrentHashMap<URI, AtomicInteger>();

    public boolean isReferenced(URI uri) {
        return this.counters.get(uri) != null;
    }

    public int increment(URI uri) {
        AtomicInteger count = this.counters.get(uri);
        if (count == null) {
            count = new AtomicInteger(1);
            this.counters.put(uri, count);
            return count.get();
        }
        return count.incrementAndGet();
    }

    public void incrementImported(ClassLoader classLoader) {
        if (classLoader instanceof MultiParentClassLoader) {
            MultiParentClassLoader cl = (MultiParentClassLoader)classLoader;
            URI uri = cl.getName();
            AtomicInteger count = this.counters.get(uri);
            if (count == null) {
                count = new AtomicInteger(1);
                this.counters.put(uri, count);
            } else {
                count.incrementAndGet();
            }
            for (ClassLoader parent : cl.getParents()) {
                if (parent == null) continue;
                this.incrementImported(parent);
            }
        } else {
            ClassLoader parent = classLoader.getParent();
            if (parent != null) {
                this.incrementImported(parent);
            }
        }
    }

    public int decrement(ClassLoader classLoader) {
        if (classLoader instanceof MultiParentClassLoader) {
            MultiParentClassLoader cl = (MultiParentClassLoader)classLoader;
            int result = this.decrementCount(cl);
            for (ClassLoader parent : cl.getParents()) {
                this.decrement(parent);
            }
            return result;
        }
        ClassLoader parent = classLoader.getParent();
        if (parent != null) {
            this.decrement(parent);
        }
        return -1;
    }

    private int decrementCount(MultiParentClassLoader classLoader) {
        URI uri = classLoader.getName();
        AtomicInteger count = this.counters.get(uri);
        if (count != null) {
            int val = count.decrementAndGet();
            if (val == 0) {
                this.counters.remove(uri);
            }
            return val;
        }
        return 0;
    }
}

