/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.builder.transform;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.fabric.builder.transform.NoTransformerException;
import org.fabric3.fabric.builder.transform.TransformerInterceptor;
import org.fabric3.fabric.builder.transform.TransformerInterceptorFactory;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.model.physical.ParameterTypeHelper;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.wire.Interceptor;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerInterceptorFactoryImpl
implements TransformerInterceptorFactory {
    private TransformerRegistry registry;

    public TransformerInterceptorFactoryImpl(@Reference TransformerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Interceptor createInterceptor(PhysicalOperationDefinition definition, List<DataType<?>> sources, List<DataType<?>> targets, ClassLoader targetLoader, ClassLoader sourceLoader) throws WiringException {
        List<Class<?>> targetTypes = this.loadTargetInputTypes(definition, targetLoader);
        List<Class<?>> sourceTypes = this.loadSourceInputTypes(definition, targetLoader);
        try {
            Transformer inTransformer = null;
            DataType<?> selectedSource = null;
            DataType<?> selectedTarget = null;
            for (DataType<?> source : sources) {
                for (DataType<?> target : targets) {
                    inTransformer = this.registry.getTransformer(source, target, sourceTypes, targetTypes);
                    if (inTransformer == null) continue;
                    selectedSource = source;
                    selectedTarget = target;
                    break;
                }
                if (selectedSource == null) continue;
                break;
            }
            if (inTransformer == null) {
                throw new NoTransformerException("No transformer found for operation: " + definition.getName());
            }
            List<Class<?>> sourceOutTypes = this.loadSourceOutputTypes(definition, targetLoader);
            List<Class<?>> targetOutTypes = this.loadTargetOutputTypes(definition, targetLoader);
            Transformer outTransformer = this.registry.getTransformer(selectedTarget, selectedSource, targetOutTypes, sourceOutTypes);
            if (outTransformer == null) {
                throw new NoTransformerException("No transformer from type " + selectedTarget + " to type " + selectedSource);
            }
            return new TransformerInterceptor((Transformer<Object, Object>)inTransformer, (Transformer<Object, Object>)outTransformer, targetLoader, sourceLoader);
        }
        catch (TransformationException e) {
            throw new WiringException((Throwable)e);
        }
    }

    private List<Class<?>> loadSourceInputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws WiringException {
        try {
            return ParameterTypeHelper.loadSourceInParameterTypes((PhysicalOperationDefinition)definition, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            throw new WiringException((Throwable)e);
        }
    }

    private List<Class<?>> loadTargetInputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws WiringException {
        try {
            return ParameterTypeHelper.loadTargetInParameterTypes((PhysicalOperationDefinition)definition, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            throw new WiringException((Throwable)e);
        }
    }

    private List<Class<?>> loadSourceOutputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws WiringException {
        ArrayList types = new ArrayList();
        try {
            Class outParam = ParameterTypeHelper.loadSourceOutputType((PhysicalOperationDefinition)definition, (ClassLoader)loader);
            types.add(outParam);
        }
        catch (ClassNotFoundException e) {
            throw new WiringException((Throwable)e);
        }
        return types;
    }

    private List<Class<?>> loadTargetOutputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws WiringException {
        ArrayList types = new ArrayList();
        try {
            Class outParam = ParameterTypeHelper.loadTargetOutputType((PhysicalOperationDefinition)definition, (ClassLoader)loader);
            types.add(outParam);
        }
        catch (ClassNotFoundException e) {
            throw new WiringException((Throwable)e);
        }
        return types;
    }
}

