/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.channel;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.fabric.channel.FanOutHandler;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.PassThroughHandler;

public class ChannelImpl
implements Channel {
    private URI uri;
    private QName deployable;
    private EventStreamHandler headHandler;
    private EventStreamHandler tailHandler;
    private EventStreamHandler inHandler;
    private FanOutHandler fanOutHandler;

    public ChannelImpl(URI uri, QName deployable, FanOutHandler fanOutHandler) {
        this.uri = uri;
        this.deployable = deployable;
        this.inHandler = new PassThroughHandler();
        this.fanOutHandler = fanOutHandler;
        this.inHandler.setNext((EventStreamHandler)this.fanOutHandler);
    }

    public ChannelImpl(URI uri, QName deployable, EventStreamHandler inHandler, FanOutHandler fanOutHandler) {
        this.uri = uri;
        this.deployable = deployable;
        this.inHandler = inHandler;
        this.fanOutHandler = fanOutHandler;
        this.inHandler.setNext((EventStreamHandler)fanOutHandler);
    }

    public URI getUri() {
        return this.uri;
    }

    public QName getDeployable() {
        return this.deployable;
    }

    public void addHandler(EventStreamHandler handler) {
        if (this.headHandler == null) {
            this.headHandler = handler;
            this.inHandler.setNext(handler);
        } else {
            this.tailHandler.setNext(handler);
        }
        this.tailHandler = handler;
        this.tailHandler.setNext((EventStreamHandler)this.fanOutHandler);
    }

    public void removeHandler(EventStreamHandler handler) {
        EventStreamHandler previous = null;
        for (EventStreamHandler current = this.headHandler; current != null; current = current.getNext()) {
            if (current == handler) {
                if (this.headHandler == current) {
                    this.headHandler = current.getNext();
                }
                if (this.tailHandler == current) {
                    EventStreamHandler eventStreamHandler = this.tailHandler = previous == null ? this.headHandler : previous;
                }
                if (previous != null) {
                    previous.setNext(current.getNext());
                }
                this.inHandler.setNext(this.headHandler);
                return;
            }
            previous = current;
        }
    }

    public void attach(EventStreamHandler handler) {
        handler.setNext(this.inHandler);
    }

    public void attach(ChannelConnection connection) {
        for (EventStream stream : connection.getEventStreams()) {
            stream.getTailHandler().setNext(this.inHandler);
        }
    }

    public void subscribe(URI uri, ChannelConnection connection) {
        this.fanOutHandler.addConnection(uri, connection);
    }

    public ChannelConnection unsubscribe(URI uri) {
        return this.fanOutHandler.removeConnection(uri);
    }
}

