/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.channel;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.fabric.channel.DuplicateChannelException;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelManager;

public class ChannelManagerImpl
implements ChannelManager {
    private Map<URI, Channel> channels = new ConcurrentHashMap<URI, Channel>();

    public Channel getChannel(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Channel URI was null");
        }
        return this.channels.get(uri);
    }

    public void register(Channel channel) throws DuplicateChannelException {
        URI uri = channel.getUri();
        if (this.channels.containsKey(uri)) {
            throw new DuplicateChannelException("Channel already exists: " + uri);
        }
        this.channels.put(uri, channel);
    }

    public Channel unregister(URI uri) {
        return this.channels.remove(uri);
    }
}

