/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.channel;

import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.PassThroughHandler;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;

public class EventStreamImpl
implements EventStream {
    private PhysicalEventStreamDefinition definition;
    private EventStreamHandler headHandler;
    private EventStreamHandler tailHandler;

    public EventStreamImpl(PhysicalEventStreamDefinition definition) {
        this.definition = definition;
        PassThroughHandler handler = new PassThroughHandler();
        this.addHandler((EventStreamHandler)handler);
    }

    public PhysicalEventStreamDefinition getDefinition() {
        return this.definition;
    }

    public EventStreamHandler getHeadHandler() {
        return this.headHandler;
    }

    public EventStreamHandler getTailHandler() {
        return this.tailHandler;
    }

    public void addHandler(EventStreamHandler handler) {
        if (this.headHandler == null) {
            this.headHandler = handler;
        } else {
            this.tailHandler.setNext(handler);
        }
        this.tailHandler = handler;
    }

    public void addHandler(int index, EventStreamHandler handler) {
        EventStreamHandler next;
        int i = 0;
        EventStreamHandler prev = null;
        for (next = this.headHandler; next != null && i < index; next = next.getNext(), ++i) {
            prev = next;
        }
        if (i == index) {
            if (prev != null) {
                prev.setNext(handler);
            } else {
                this.headHandler = handler;
            }
            handler.setNext(next);
            if (next == null) {
                this.tailHandler = handler;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }
}

