/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.channel;

import java.io.Serializable;
import org.fabric3.fabric.channel.ReplicationMonitor;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.EventWrapper;
import org.fabric3.spi.federation.MessageException;
import org.fabric3.spi.federation.MessageReceiver;
import org.fabric3.spi.federation.ZoneTopologyService;

public class ReplicationHandler
implements EventStreamHandler,
MessageReceiver {
    private String channelName;
    private ZoneTopologyService topologyService;
    private EventStreamHandler next;
    private ReplicationMonitor monitor;

    public ReplicationHandler(String channelName, ZoneTopologyService topologyService, ReplicationMonitor monitor) {
        this.topologyService = topologyService;
        this.channelName = channelName;
        this.monitor = monitor;
    }

    public void setNext(EventStreamHandler next) {
        this.next = next;
    }

    public EventStreamHandler getNext() {
        return this.next;
    }

    public void handle(Object event) {
        if (!(event instanceof EventWrapper) && event instanceof Serializable) {
            try {
                this.topologyService.sendAsynchronous(this.channelName, (Serializable)event);
            }
            catch (MessageException e) {
                this.monitor.error(e);
            }
        }
        this.next.handle(event);
    }

    public void onMessage(Object event) {
        this.next.handle(event);
    }
}

