/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.channel;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.EventWrapper;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerHandler
implements EventStreamHandler {
    private EventStreamHandler next;
    private DataType<Object> targetType;
    private TransformerRegistry registry;
    private List<Class<?>> typeList;
    private Map<DataType<?>, Transformer<Object, Object>> cache;

    public TransformerHandler(DataType<Object> targetType, TransformerRegistry registry) {
        this.targetType = targetType;
        this.registry = registry;
        Class clazz = targetType.getPhysical();
        this.typeList = (List)this.cast(Collections.singletonList(clazz));
    }

    public void handle(Object event) {
        if (event instanceof EventWrapper) {
            if (this.cache == null) {
                this.cache = new ConcurrentHashMap();
            }
            EventWrapper wrapper = (EventWrapper)event;
            Object content = ((EventWrapper)event).getEvent(this.targetType);
            if (content == null) {
                try {
                    DataType type = wrapper.getType();
                    ClassLoader loader = this.targetType.getClass().getClassLoader();
                    Transformer transformer = this.cache.get(type);
                    if (transformer == null) {
                        transformer = this.registry.getTransformer(type, this.targetType, this.typeList, this.typeList);
                        this.cache.put(type, (Transformer<Object, Object>)transformer);
                    }
                    content = transformer.transform(wrapper.getEvent(), loader);
                    wrapper.cache(this.targetType, content);
                }
                catch (TransformationException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
            }
            event = new Object[]{content};
        }
        this.next.handle((Object)event);
    }

    public void setNext(EventStreamHandler next) {
        this.next = next;
    }

    public EventStreamHandler getNext() {
        return this.next;
    }

    private <T> T cast(Object o) {
        return (T)o;
    }
}

