/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.classloader;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.spi.classloader.ClassLoaderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderRegistryImpl
implements ClassLoaderRegistry {
    private final Map<URI, ClassLoader> registry = new ConcurrentHashMap<URI, ClassLoader>();
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap();

    public synchronized void register(URI id, ClassLoader classLoader) {
        if (this.registry.containsKey(id)) {
            throw new AssertionError((Object)("Duplicate class loader: " + id));
        }
        this.registry.put(id, classLoader);
    }

    public ClassLoader unregister(URI id) {
        return this.registry.remove(id);
    }

    public ClassLoader getClassLoader(URI id) {
        return this.registry.get(id);
    }

    public Map<URI, ClassLoader> getClassLoaders() {
        return this.registry;
    }

    public Class<?> loadClass(URI classLoaderId, String className) throws ClassNotFoundException {
        ClassLoader cl = this.getClassLoader(classLoaderId);
        return this.loadClass(cl, className);
    }

    public Class<?> loadClass(ClassLoader cl, String className) throws ClassNotFoundException {
        Class<?> clazz = PRIMITIVES.get(className);
        if (clazz == null) {
            clazz = Class.forName(className, true, cl);
        }
        return clazz;
    }

    static {
        PRIMITIVES.put("boolean", Boolean.TYPE);
        PRIMITIVES.put("byte", Byte.TYPE);
        PRIMITIVES.put("short", Short.TYPE);
        PRIMITIVES.put("int", Integer.TYPE);
        PRIMITIVES.put("long", Long.TYPE);
        PRIMITIVES.put("float", Float.TYPE);
        PRIMITIVES.put("double", Double.TYPE);
        PRIMITIVES.put("void", Void.TYPE);
    }
}

