/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.classloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiClassLoaderObjectInputStream;
import org.fabric3.spi.classloader.MultiClassLoaderObjectOutputStream;
import org.fabric3.spi.classloader.SerializationService;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationServiceImpl
implements SerializationService {
    private ClassLoaderRegistry classLoaderRegistry;

    public SerializationServiceImpl(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public byte[] serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        MultiClassLoaderObjectOutputStream stream = new MultiClassLoaderObjectOutputStream((OutputStream)bas);
        stream.writeObject((Object)serializable);
        stream.close();
        return bas.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(Class<T> type, byte[] payload) throws IOException, ClassNotFoundException {
        MultiClassLoaderObjectInputStream ois = null;
        ByteArrayInputStream stream = new ByteArrayInputStream(payload);
        ois = new MultiClassLoaderObjectInputStream((InputStream)stream, this.classLoaderRegistry);
        T t = type.cast(ois.readObject());
        return t;
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

