/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.component.scope;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.component.scope.ScopeContainerMonitor;
import org.fabric3.fabric.component.scope.SingletonScopeContainer;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.GroupInitializationException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopedComponent;
import org.fabric3.spi.federation.TopologyListener;
import org.fabric3.spi.federation.ZoneTopologyService;
import org.fabric3.spi.invocation.WorkContext;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Service(names={ScopeContainer.class, TopologyListener.class})
public class DomainScopeContainer
extends SingletonScopeContainer
implements TopologyListener {
    private HostInfo info;
    private ZoneTopologyService topologyService;
    private final List<QName> deferredContexts = new ArrayList<QName>();
    boolean activated;

    public DomainScopeContainer(@Reference HostInfo info, @Monitor ScopeContainerMonitor monitor) {
        super(Scope.DOMAIN, monitor);
        this.info = info;
    }

    @Reference(required=false)
    public void setTopologyService(List<ZoneTopologyService> topologyServices) {
        if (topologyServices.size() > 0) {
            this.topologyService = topologyServices.get(0);
        }
    }

    @Override
    @Init
    public void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Destroy
    public synchronized void stop() {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContext(QName deployable, WorkContext workContext) throws GroupInitializationException {
        if (RuntimeMode.PARTICIPANT == this.info.getRuntimeMode() && this.topologyService == null) {
            return;
        }
        if (RuntimeMode.PARTICIPANT == this.info.getRuntimeMode() && !this.topologyService.isZoneLeader()) {
            List<QName> list = this.deferredContexts;
            synchronized (list) {
                this.deferredContexts.add(deployable);
            }
            return;
        }
        this.activated = true;
        super.startContext(deployable, workContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContext(QName deployable, WorkContext workContext) {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.remove(deployable);
        }
        super.stopContext(deployable, workContext);
    }

    @Override
    public Object getInstance(ScopedComponent component, WorkContext workContext) throws InstanceLifecycleException {
        if (this.topologyService != null && !this.activated) {
            throw new InstanceLifecycleException("Component instance not active: " + component.getUri());
        }
        return super.getInstance(component, workContext);
    }

    public void onJoin(String name) {
    }

    public void onLeave(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaderElected(String name) {
        if (this.topologyService != null && !this.topologyService.isZoneLeader()) {
            return;
        }
        this.activated = true;
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            for (QName deployable : this.deferredContexts) {
                WorkContext workContext = new WorkContext();
                try {
                    super.startContext(deployable, workContext);
                }
                catch (GroupInitializationException e) {
                    this.monitor.leaderElectionError((Exception)((Object)e));
                }
            }
            this.deferredContexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllContexts(WorkContext workContext) {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stopAllContexts(workContext);
    }
}

