/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.component.scope;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.component.scope.AbstractScopeContainer;
import org.fabric3.fabric.component.scope.ScopeContainerMonitor;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.GroupInitializationException;
import org.fabric3.spi.component.InstanceDestructionException;
import org.fabric3.spi.component.InstanceInitException;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.ScopedComponent;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.objectfactory.ObjectCreationException;
import org.oasisopen.sca.annotation.Destroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingletonScopeContainer
extends AbstractScopeContainer {
    private static final Object EMPTY = new Object();
    private final Map<ScopedComponent, Object> instances;
    private final Map<QName, List<Pair>> destroyQueues;
    private final Map<QName, List<ScopedComponent>> initQueues = new HashMap<QName, List<ScopedComponent>>();
    private final Map<ScopedComponent, CountDownLatch> pending;

    protected SingletonScopeContainer(Scope scope, @Monitor ScopeContainerMonitor monitor) {
        super(scope, monitor);
        this.instances = new ConcurrentHashMap<ScopedComponent, Object>();
        this.pending = new ConcurrentHashMap<ScopedComponent, CountDownLatch>();
        this.destroyQueues = new LinkedHashMap<QName, List<Pair>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ScopedComponent component) {
        super.register(component);
        if (component.isEagerInit()) {
            QName deployable = component.getDeployable();
            Map<QName, List<ScopedComponent>> map = this.initQueues;
            synchronized (map) {
                List<ScopedComponent> initQueue = this.initQueues.get(deployable);
                if (initQueue == null) {
                    initQueue = new ArrayList<ScopedComponent>();
                    this.initQueues.put(deployable, initQueue);
                }
                initQueue.add(component);
            }
        }
        this.instances.put(component, EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ScopedComponent component) {
        super.unregister(component);
        this.instances.remove(component);
        if (component.isEagerInit()) {
            QName deployable = component.getDeployable();
            Map<QName, List<ScopedComponent>> map = this.initQueues;
            synchronized (map) {
                List<ScopedComponent> initQueue = this.initQueues.get(deployable);
                initQueue.remove(component);
                if (initQueue.isEmpty()) {
                    this.initQueues.remove(deployable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContext(QName deployable, WorkContext workContext) throws GroupInitializationException {
        this.eagerInitialize(workContext, deployable);
        Map<QName, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            if (!this.destroyQueues.containsKey(deployable)) {
                this.destroyQueues.put(deployable, new ArrayList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopContext(QName deployable, WorkContext workContext) {
        Map<QName, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            List<Pair> list = this.destroyQueues.get(deployable);
            if (list == null) {
                return;
            }
            this.destroyInstances(list, workContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Destroy
    public synchronized void stop() {
        super.stop();
        Map<QName, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            this.destroyQueues.clear();
        }
        map = this.initQueues;
        synchronized (map) {
            this.initQueues.clear();
        }
        this.instances.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstance(ScopedComponent component, WorkContext workContext) throws InstanceLifecycleException {
        CountDownLatch latch;
        Object instance = this.instances.get(component);
        if (instance != EMPTY && instance != null) {
            return instance;
        }
        ScopedComponent scopedComponent = component;
        synchronized (scopedComponent) {
            latch = this.pending.get(component);
            if (latch != null) {
                try {
                    latch.await(5L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InstanceInitException("Error creating instance for: " + component.getUri(), (Throwable)e);
                }
                return this.instances.get(component);
            }
            latch = new CountDownLatch(1);
            this.pending.put(component, latch);
        }
        try {
            List<Pair> queue;
            instance = component.createInstance(workContext);
            component.startInstance(instance, workContext);
            QName deployable = component.getDeployable();
            Object object = this.destroyQueues;
            synchronized (object) {
                queue = this.destroyQueues.get(deployable);
                if (queue == null) {
                    queue = new ArrayList<Pair>();
                    this.destroyQueues.put(deployable, queue);
                }
            }
            queue.add(new Pair(component, instance));
            this.instances.put(component, instance);
            latch.countDown();
            object = instance;
            return object;
        }
        catch (ObjectCreationException e) {
            throw new InstanceInitException("Error creating instance for: " + component.getUri(), (Throwable)e);
        }
        finally {
            this.pending.remove(component);
        }
    }

    public void releaseInstance(ScopedComponent component, Object instance, WorkContext workContext) {
    }

    public List<Object> getActiveInstances(ScopedComponent component) {
        Object instance = this.instances.get(component);
        if (instance == null || instance == EMPTY) {
            return Collections.emptyList();
        }
        return Collections.singletonList(instance);
    }

    public void reinject() throws InstanceLifecycleException {
        for (Map.Entry<ScopedComponent, Object> entry : this.instances.entrySet()) {
            ScopedComponent component = entry.getKey();
            Object instance = entry.getValue();
            component.reinject(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllContexts(WorkContext workContext) {
        Map<QName, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            ArrayList<List<Pair>> queues = new ArrayList<List<Pair>>(this.destroyQueues.values());
            ListIterator iter = queues.listIterator(queues.size());
            while (iter.hasPrevious()) {
                List queue = (List)iter.previous();
                this.destroyInstances(queue, workContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eagerInitialize(WorkContext workContext, QName contextId) throws GroupInitializationException {
        List<ScopedComponent> initQueue;
        Map<QName, List<ScopedComponent>> map = this.initQueues;
        synchronized (map) {
            initQueue = this.initQueues.get(contextId);
            if (initQueue != null) {
                initQueue = new ArrayList<ScopedComponent>(initQueue);
            }
        }
        if (initQueue != null) {
            this.initializeComponents(initQueue, workContext);
        }
    }

    private void initializeComponents(List<ScopedComponent> components, WorkContext workContext) throws GroupInitializationException {
        LinkedHashSet<URI> causes = null;
        for (ScopedComponent component : components) {
            try {
                this.getInstance(component, workContext);
            }
            catch (Exception e) {
                if (causes == null) {
                    causes = new LinkedHashSet<URI>();
                }
                URI uri = component.getUri();
                this.monitor.initializationError(uri, component.getDeployable(), e);
                causes.add(uri);
            }
        }
        if (causes != null) {
            throw new GroupInitializationException(causes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInstances(List<Pair> instances, WorkContext workContext) {
        while (true) {
            Pair toDestroy;
            List<Pair> list = instances;
            synchronized (list) {
                if (instances.size() == 0) {
                    return;
                }
                toDestroy = instances.remove(instances.size() - 1);
            }
            ScopedComponent component = toDestroy.component;
            try {
                Object instance = toDestroy.instance;
                component.stopInstance(instance, workContext);
                continue;
            }
            catch (InstanceDestructionException e) {
                this.monitor.destructionError(component.getUri(), component.getDeployable(), e);
                continue;
            }
            break;
        }
    }

    private class Pair {
        private ScopedComponent component;
        private Object instance;

        private Pair(ScopedComponent component, Object instance) {
            this.component = component;
            this.instance = instance;
        }
    }
}

