/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.contract;

import org.fabric3.spi.contract.ContractMatcherExtension;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaContractMatcherExtension
implements ContractMatcherExtension<JavaServiceContract, JavaServiceContract> {
    private static final MatchResult MATCH = new MatchResult(true);
    private static final MatchResult NO_MATCH = new MatchResult(false);

    public Class<JavaServiceContract> getSource() {
        return JavaServiceContract.class;
    }

    public Class<JavaServiceContract> getTarget() {
        return JavaServiceContract.class;
    }

    public MatchResult isAssignableFrom(JavaServiceContract source, JavaServiceContract target, boolean reportErrors) {
        if (source == target) {
            return MATCH;
        }
        if (source.getSuperType() == null && target.getSuperType() != null || source.getSuperType() != null && !source.getSuperType().equals(target.getSuperType())) {
            if (reportErrors) {
                return new MatchResult("Types are not in the same type hierarchy");
            }
            return NO_MATCH;
        }
        if (source.getInterfaceClass().equals(target.getInterfaceClass())) {
            for (Signature signature : source.getMethodSignatures()) {
                if (target.getMethodSignatures().contains(signature)) continue;
                if (reportErrors) {
                    return new MatchResult("Method signature not found on target service contract: " + signature);
                }
                return NO_MATCH;
            }
            return MATCH;
        }
        for (String superType : target.getInterfaces()) {
            if (!superType.equals(source.getInterfaceClass())) continue;
            return MATCH;
        }
        if (!source.isRemotable() || !target.isRemotable()) {
            if (reportErrors) {
                return new MatchResult("Source and target interfaces do not match");
            }
            return NO_MATCH;
        }
        for (Signature signature : source.getMethodSignatures()) {
            if (target.getMethodSignatures().contains(signature)) continue;
            if (reportErrors) {
                return new MatchResult("Method signature not found on target service contract: " + signature);
            }
            return NO_MATCH;
        }
        return MATCH;
    }
}

