/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.fabric.collector.Collector;
import org.fabric3.fabric.domain.CompositeNotDeployedException;
import org.fabric3.fabric.domain.ContributionHelper;
import org.fabric3.fabric.domain.DeploymentPlanNotFoundException;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.LogicalModelInstantiator;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.domain.AssemblyException;
import org.fabric3.host.domain.CompositeAlreadyDeployedException;
import org.fabric3.host.domain.ContributionNotFoundException;
import org.fabric3.host.domain.ContributionNotInstalledException;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.domain.DomainJournal;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.Include;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.allocator.AllocationException;
import org.fabric3.spi.allocator.Allocator;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.domain.DeployListener;
import org.fabric3.spi.domain.Deployer;
import org.fabric3.spi.domain.DeploymentPackage;
import org.fabric3.spi.generator.Deployment;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.generator.Generator;
import org.fabric3.spi.generator.policy.PolicyActivationException;
import org.fabric3.spi.generator.policy.PolicyAttacher;
import org.fabric3.spi.generator.policy.PolicyRegistry;
import org.fabric3.spi.generator.policy.PolicyResolutionException;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.instance.CopyUtil;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.plan.DeploymentPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDomain
implements Domain {
    private static final String SYNTHETIC_PLAN_NAME = "fabric3.synthetic";
    private static final DeploymentPlan SYNTHETIC_PLAN = new DeploymentPlan("fabric3.synthetic");
    protected Deployer deployer;
    protected Generator generator;
    protected PolicyRegistry policyRegistry;
    protected boolean generateFullDeployment;
    protected List<DeployListener> listeners;
    protected MetaDataStore metadataStore;
    protected LogicalComponentManager logicalComponentManager;
    protected LogicalModelInstantiator logicalModelInstantiator;
    protected PolicyAttacher policyAttacher;
    protected Collector collector;
    protected ContributionHelper contributionHelper;
    protected HostInfo info;
    protected Allocator allocator;

    public AbstractDomain(MetaDataStore metadataStore, LogicalComponentManager lcm, Generator generator, LogicalModelInstantiator instantiator, PolicyAttacher policyAttacher, Deployer deployer, Collector collector, ContributionHelper contributionHelper, HostInfo info) {
        this.metadataStore = metadataStore;
        this.generator = generator;
        this.logicalModelInstantiator = instantiator;
        this.logicalComponentManager = lcm;
        this.policyAttacher = policyAttacher;
        this.deployer = deployer;
        this.collector = collector;
        this.contributionHelper = contributionHelper;
        this.info = info;
        this.listeners = Collections.emptyList();
    }

    public synchronized void include(QName deployable) throws DeploymentException {
        this.include(deployable, null);
    }

    public synchronized void include(QName deployable, String planName) throws DeploymentException {
        DeploymentPlan plan;
        Composite wrapper = this.createWrapper(deployable);
        if (planName == null) {
            if (RuntimeMode.CONTROLLER == this.info.getRuntimeMode() && !this.isLocal()) {
                plan = this.contributionHelper.findDefaultPlan(deployable);
                if (plan == null) {
                    plan = SYNTHETIC_PLAN;
                }
            } else {
                plan = SYNTHETIC_PLAN;
            }
        } else {
            plan = this.contributionHelper.findPlan(planName);
            if (plan == null) {
                throw new DeploymentPlanNotFoundException("Deployment plan not found: " + planName);
            }
        }
        for (DeployListener listener : this.listeners) {
            listener.onDeploy(deployable, plan.getName());
        }
        this.instantiateAndDeploy(wrapper, plan, false);
        for (DeployListener listener : this.listeners) {
            listener.onDeployCompleted(deployable, plan.getName());
        }
    }

    public synchronized void include(Composite composite, boolean simulated) throws DeploymentException {
        QName name = composite.getName();
        for (DeployListener listener : this.listeners) {
            listener.onDeploy(name, SYNTHETIC_PLAN_NAME);
        }
        this.instantiateAndDeploy(composite, SYNTHETIC_PLAN, simulated);
    }

    public synchronized void include(List<URI> uris) throws DeploymentException {
        Set<Contribution> contributions = this.contributionHelper.findContributions(uris);
        List<Composite> deployables = this.contributionHelper.getDeployables(contributions);
        if (RuntimeMode.CONTROLLER == this.info.getRuntimeMode() && !this.isLocal()) {
            DeploymentPlan plan;
            URI uri;
            QName name;
            HashMap<URI, DeploymentPlan> plans = new HashMap<URI, DeploymentPlan>();
            for (Contribution contribution : contributions) {
                URI uri2 = contribution.getUri();
                DeploymentPlan defaultPlan = this.contributionHelper.findDefaultPlan(contribution);
                if (defaultPlan == null) {
                    defaultPlan = SYNTHETIC_PLAN;
                }
                plans.put(uri2, defaultPlan);
            }
            DeploymentPlan merged = this.merge(plans.values());
            for (URI uri2 : uris) {
                for (DeployListener listener : this.listeners) {
                    listener.onDeploy(uri2);
                }
            }
            for (Composite deployable : deployables) {
                name = deployable.getName();
                for (DeployListener listener : this.listeners) {
                    uri = deployable.getContributionUri();
                    plan = (DeploymentPlan)plans.get(uri);
                    listener.onDeploy(name, plan.getName());
                }
            }
            this.instantiateAndDeploy(deployables, contributions, merged, false);
            for (Composite deployable : deployables) {
                name = deployable.getName();
                for (DeployListener listener : this.listeners) {
                    uri = deployable.getContributionUri();
                    plan = (DeploymentPlan)plans.get(uri);
                    listener.onDeployCompleted(name, plan.getName());
                }
            }
            for (URI uri2 : uris) {
                for (DeployListener listener : this.listeners) {
                    listener.onDeployCompleted(uri2);
                }
            }
        } else {
            for (URI uri : uris) {
                for (DeployListener listener : this.listeners) {
                    listener.onDeploy(uri);
                }
            }
            for (Composite deployable : deployables) {
                for (DeployListener listener : this.listeners) {
                    listener.onDeploy(deployable.getName(), SYNTHETIC_PLAN_NAME);
                }
            }
            this.instantiateAndDeploy(deployables, contributions, SYNTHETIC_PLAN, false);
            for (Composite deployable : deployables) {
                for (DeployListener listener : this.listeners) {
                    listener.onDeployCompleted(deployable.getName(), SYNTHETIC_PLAN_NAME);
                }
            }
            for (URI uri : uris) {
                for (DeployListener listener : this.listeners) {
                    listener.onDeployCompleted(uri);
                }
            }
        }
    }

    public synchronized void undeploy(URI uri, boolean force) throws DeploymentException {
        Contribution contribution = this.metadataStore.find(uri);
        if (contribution == null) {
            throw new ContributionNotFoundException("Contribution not found: " + uri);
        }
        List deployables = contribution.getManifest().getDeployables();
        if (deployables.isEmpty()) {
            return;
        }
        ArrayList<QName> names = new ArrayList<QName>();
        ListIterator iter = deployables.listIterator(deployables.size());
        while (iter.hasPrevious()) {
            names.add(((Deployable)iter.previous()).getName());
        }
        for (QName deployable : names) {
            if (contribution.getLockOwners().contains(deployable)) continue;
            throw new CompositeNotDeployedException("Composite is not deployed: " + deployable);
        }
        for (QName deployable : names) {
            for (DeployListener listener : this.listeners) {
                listener.onUndeploy(deployable);
            }
        }
        for (DeployListener listener : this.listeners) {
            listener.onUnDeploy(uri);
        }
        LogicalCompositeComponent domain = this.logicalComponentManager.getRootComponent();
        if (this.isTransactional()) {
            domain = CopyUtil.copy((LogicalCompositeComponent)domain);
        }
        for (QName deployable : names) {
            this.collector.markForCollection(deployable, domain);
        }
        try {
            Deployment deployment = this.generator.generate(domain, true);
            this.collector.collect(domain);
            Deployment fullDeployment = null;
            if (this.generateFullDeployment) {
                fullDeployment = this.generator.generate(domain, false);
            }
            DeploymentPackage deploymentPackage = new DeploymentPackage(deployment, fullDeployment);
            try {
                this.deployer.deploy(deploymentPackage);
            }
            catch (DeploymentException e) {
                if (!force) {
                    throw e;
                }
            }
        }
        catch (GenerationException e) {
            StringBuffer list = new StringBuffer();
            for (QName deployable : names) {
                list.append(" ").append(deployable);
            }
            throw new DeploymentException("Error undeploying:" + list, (Throwable)e);
        }
        int deployablesSize = names.size();
        for (int i = 0; i < deployablesSize; ++i) {
            QName deployable = (QName)names.get(i);
            contribution.releaseLock(deployable);
        }
        this.logicalComponentManager.replaceRootComponent(domain);
        for (QName deployable : names) {
            for (DeployListener listener : this.listeners) {
                listener.onUndeployCompleted(deployable);
            }
        }
        for (DeployListener listener : this.listeners) {
            listener.onUnDeployCompleted(uri);
        }
    }

    public synchronized void undeploy(Composite composite, boolean simulated) throws DeploymentException {
        QName deployable = composite.getName();
        for (DeployListener listener : this.listeners) {
            listener.onUndeploy(deployable);
        }
        LogicalCompositeComponent domain = this.logicalComponentManager.getRootComponent();
        if (this.isTransactional()) {
            domain = CopyUtil.copy((LogicalCompositeComponent)domain);
        }
        this.collector.markForCollection(deployable, domain);
        try {
            if (!simulated) {
                Deployment deployment = this.generator.generate(domain, true);
                this.collector.collect(domain);
                Deployment fullDeployment = null;
                if (this.generateFullDeployment) {
                    fullDeployment = this.generator.generate(domain, false);
                }
                DeploymentPackage deploymentPackage = new DeploymentPackage(deployment, fullDeployment);
                this.deployer.deploy(deploymentPackage);
            } else {
                this.collector.collect(domain);
            }
            URI uri = composite.getContributionUri();
            Contribution contribution = this.metadataStore.find(uri);
            contribution.releaseLock(deployable);
        }
        catch (GenerationException e) {
            throw new DeploymentException("Error undeploying:" + deployable);
        }
        this.logicalComponentManager.replaceRootComponent(domain);
        for (DeployListener listener : this.listeners) {
            listener.onUndeployCompleted(deployable);
        }
    }

    public synchronized void activateDefinitions(URI uri) throws DeploymentException {
        this.activateAndDeployDefinitions(uri, false);
    }

    public synchronized void deactivateDefinitions(URI uri) throws DeploymentException {
        Contribution contribution = this.metadataStore.find(uri);
        if (ContributionState.INSTALLED != contribution.getState()) {
            throw new ContributionNotInstalledException("Contribution is not installed: " + uri);
        }
        try {
            Set policySets = this.policyRegistry.deactivateDefinitions(uri);
            if (!policySets.isEmpty()) {
                this.undeployPolicySets(policySets);
            }
        }
        catch (PolicyActivationException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void recover(DomainJournal journal) throws DeploymentException {
        for (URI uri : journal.getContributions()) {
            this.activateAndDeployDefinitions(uri, true);
        }
        Map deployables = journal.getDeployables();
        LinkedHashSet<Contribution> contributions = new LinkedHashSet<Contribution>();
        ArrayList<DeploymentPlan> plans = new ArrayList<DeploymentPlan>();
        for (Map.Entry entry : deployables.entrySet()) {
            DeploymentPlan plan;
            QName deployable = (QName)entry.getKey();
            String planName = (String)entry.getValue();
            QNameSymbol symbol = new QNameSymbol(deployable);
            ResourceElement element = this.metadataStore.find(Composite.class, (Symbol)symbol);
            if (element == null) {
                throw new DeploymentException("Contribution containing the deployable not found: " + deployable + ". The domain journal (domain.xml) may be out of sync.");
            }
            Contribution contribution = element.getResource().getContribution();
            if (contribution == null) {
                throw new DeploymentException("Contribution for deployable not found: " + deployable);
            }
            contributions.add(contribution);
            if (SYNTHETIC_PLAN_NAME.equals(planName)) {
                if (RuntimeMode.CONTROLLER == this.info.getRuntimeMode()) {
                    plan = this.contributionHelper.findDefaultPlan(deployable);
                    if (plan == null) {
                        plan = SYNTHETIC_PLAN;
                    }
                } else {
                    plan = SYNTHETIC_PLAN;
                }
            } else {
                plan = this.contributionHelper.findPlan(planName);
                if (plan == null) {
                    plan = SYNTHETIC_PLAN;
                }
            }
            if (plan == null) {
                throw new DeploymentPlanNotFoundException("Deployment plan not found: " + planName);
            }
            plans.add(plan);
        }
        DeploymentPlan merged = this.merge(plans);
        List<Composite> deployableComposites = this.contributionHelper.getDeployables(contributions);
        this.instantiateAndDeploy(deployableComposites, contributions, merged, true);
    }

    protected abstract boolean isLocal();

    protected abstract boolean isTransactional();

    protected void selectBinding(LogicalCompositeComponent domain) throws DeploymentException {
    }

    private Composite createWrapper(QName deployable) throws DeploymentException {
        Composite composite = this.contributionHelper.findComposite(deployable);
        Composite wrapper = new Composite(deployable);
        Include include = new Include();
        include.setName(deployable);
        include.setIncluded(composite);
        wrapper.add(include);
        return wrapper;
    }

    private DeploymentPlan merge(Collection<DeploymentPlan> plans) {
        DeploymentPlan merged = new DeploymentPlan(SYNTHETIC_PLAN_NAME);
        for (DeploymentPlan plan : plans) {
            for (Map.Entry entry : plan.getDeployableMappings().entrySet()) {
                merged.addDeployableMapping((QName)entry.getKey(), (String)entry.getValue());
            }
        }
        return merged;
    }

    private void instantiateAndDeploy(List<Composite> deployables, Set<Contribution> contributions, DeploymentPlan plan, boolean recover) throws DeploymentException {
        LogicalCompositeComponent domain = this.logicalComponentManager.getRootComponent();
        for (Contribution contribution : contributions) {
            if (ContributionState.INSTALLED == contribution.getState()) continue;
            throw new ContributionNotInstalledException("Contribution is not installed: " + contribution.getUri());
        }
        this.contributionHelper.lock(contributions);
        try {
            if (this.isTransactional()) {
                domain = CopyUtil.copy((LogicalCompositeComponent)domain);
            }
            for (Contribution contribution : contributions) {
                this.activateDefinitions(contribution);
            }
            InstantiationContext context = this.logicalModelInstantiator.include(deployables, domain);
            if (context.hasErrors()) {
                this.contributionHelper.releaseLocks(contributions);
                throw new AssemblyException(context.getErrors());
            }
            this.policyAttacher.attachPolicies((LogicalComponent)domain, !recover);
            if (!recover || RuntimeMode.VM == this.info.getRuntimeMode()) {
                this.allocateAndDeploy(domain, plan);
            } else {
                this.allocate(domain, plan);
                this.selectBinding(domain);
                this.collector.markAsProvisioned(domain);
            }
            this.logicalComponentManager.replaceRootComponent(domain);
        }
        catch (DeploymentException e) {
            this.contributionHelper.releaseLocks(contributions);
            throw e;
        }
        catch (AllocationException e) {
            this.contributionHelper.releaseLocks(contributions);
            throw new DeploymentException("Error deploying composite", (Throwable)e);
        }
        catch (PolicyResolutionException e) {
            this.contributionHelper.releaseLocks(contributions);
            throw new DeploymentException("Error deploying composite", (Throwable)e);
        }
    }

    private void instantiateAndDeploy(Composite composite, DeploymentPlan plan, boolean simulated) throws DeploymentException {
        LogicalCompositeComponent domain = this.logicalComponentManager.getRootComponent();
        QName name = composite.getName();
        QNameSymbol symbol = new QNameSymbol(name);
        Contribution contribution = this.metadataStore.find(Composite.class, (Symbol)symbol).getResource().getContribution();
        if (ContributionState.INSTALLED != contribution.getState()) {
            throw new ContributionNotInstalledException("Contribution is not installed: " + contribution.getUri());
        }
        if (contribution.getLockOwners().contains(name)) {
            throw new CompositeAlreadyDeployedException("Composite has already been deployed: " + name);
        }
        contribution.acquireLock(name);
        if (this.isTransactional()) {
            domain = CopyUtil.copy((LogicalCompositeComponent)domain);
        }
        this.activateDefinitions(contribution);
        InstantiationContext context = this.logicalModelInstantiator.include(composite, domain);
        if (context.hasErrors() && !simulated) {
            contribution.releaseLock(name);
            throw new AssemblyException(context.getErrors());
        }
        try {
            this.policyAttacher.attachPolicies((LogicalComponent)domain, true);
        }
        catch (PolicyResolutionException e) {
            if (contribution.getLockOwners().contains(name)) {
                contribution.releaseLock(name);
            }
            throw new DeploymentException((Throwable)e);
        }
        if (!simulated) {
            try {
                this.allocateAndDeploy(domain, plan);
            }
            catch (DeploymentException e) {
                if (contribution.getLockOwners().contains(name)) {
                    contribution.releaseLock(name);
                }
                throw e;
            }
            this.logicalComponentManager.replaceRootComponent(domain);
        } else {
            this.collector.markAsProvisioned(domain);
            this.logicalComponentManager.replaceRootComponent(domain);
            if (context.hasErrors()) {
                throw new AssemblyException(context.getErrors());
            }
        }
    }

    private void allocateAndDeploy(LogicalCompositeComponent domain, DeploymentPlan plan) throws DeploymentException {
        try {
            this.allocate(domain, plan);
        }
        catch (AllocationException e) {
            throw new DeploymentException("Error deploying composite", (Throwable)e);
        }
        this.selectBinding(domain);
        try {
            Deployment deployment = this.generator.generate(domain, true);
            this.collector.markAsProvisioned(domain);
            Deployment fullDeployment = null;
            if (this.generateFullDeployment) {
                fullDeployment = this.generator.generate(domain, false);
            }
            DeploymentPackage deploymentPackage = new DeploymentPackage(deployment, fullDeployment);
            this.deployer.deploy(deploymentPackage);
        }
        catch (GenerationException e) {
            throw new DeploymentException("Error deploying components", (Throwable)e);
        }
    }

    private void allocate(LogicalCompositeComponent domain, DeploymentPlan plan) throws AllocationException {
        if (this.allocator == null) {
            return;
        }
        for (LogicalResource resource : domain.getResources()) {
            if (resource.getState() != LogicalState.NEW) continue;
            this.allocator.allocate(resource, plan);
        }
        for (LogicalChannel channel : domain.getChannels()) {
            if (channel.getState() != LogicalState.NEW) continue;
            this.allocator.allocate(channel, plan);
        }
        Collection components = domain.getComponents();
        for (LogicalComponent component : components) {
            if (component.getState() != LogicalState.NEW) continue;
            this.allocator.allocate(component, plan);
        }
    }

    private synchronized void activateAndDeployDefinitions(URI uri, boolean recover) throws DeploymentException {
        Contribution contribution = this.metadataStore.find(uri);
        if (contribution == null) {
            throw new DeploymentException("Contribution not installed: " + uri);
        }
        if (ContributionState.INSTALLED != contribution.getState()) {
            throw new ContributionNotInstalledException("Contribution is not installed: " + uri);
        }
        Set<PolicySet> policySets = this.activateDefinitions(contribution);
        if (!(policySets.isEmpty() || recover && RuntimeMode.VM != this.info.getRuntimeMode())) {
            this.deployPolicySets(policySets);
        }
    }

    private Set<PolicySet> activateDefinitions(Contribution contribution) throws DeploymentException {
        if (this.policyRegistry == null) {
            return Collections.emptySet();
        }
        try {
            return this.policyRegistry.activateDefinitions(contribution.getUri());
        }
        catch (PolicyActivationException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void deployPolicySets(Set<PolicySet> policySets) throws DeploymentException {
        LogicalCompositeComponent domain = this.logicalComponentManager.getRootComponent();
        if (this.isTransactional()) {
            domain = CopyUtil.copy((LogicalCompositeComponent)domain);
        }
        try {
            this.policyAttacher.attachPolicies(policySets, (LogicalComponent)domain, true);
            Deployment deployment = this.generator.generate(domain, true);
            Deployment fullDeployment = null;
            if (this.generateFullDeployment) {
                fullDeployment = this.generator.generate(domain, false);
            }
            DeploymentPackage deploymentPackage = new DeploymentPackage(deployment, fullDeployment);
            this.deployer.deploy(deploymentPackage);
            this.logicalComponentManager.replaceRootComponent(domain);
        }
        catch (PolicyResolutionException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (GenerationException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void undeployPolicySets(Set<PolicySet> policySets) throws DeploymentException {
        LogicalCompositeComponent domain = this.logicalComponentManager.getRootComponent();
        if (this.isTransactional()) {
            domain = CopyUtil.copy((LogicalCompositeComponent)domain);
        }
        try {
            this.policyAttacher.detachPolicies(policySets, (LogicalComponent)domain);
            Deployment deployment = this.generator.generate(domain, true);
            Deployment fullDeployment = null;
            if (this.generateFullDeployment) {
                fullDeployment = this.generator.generate(domain, false);
            }
            DeploymentPackage deploymentPackage = new DeploymentPackage(deployment, fullDeployment);
            this.deployer.deploy(deploymentPackage);
            this.logicalComponentManager.replaceRootComponent(domain);
        }
        catch (PolicyResolutionException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (GenerationException e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

