/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.domain.DomainMonitor;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.domain.DeployListener;
import org.oasisopen.sca.annotation.Reference;

public class DeployMonitorListener
implements DeployListener {
    private boolean enabled;
    private DomainMonitor monitor;

    public DeployMonitorListener(@Reference HostInfo info, @Monitor DomainMonitor monitor) {
        this.enabled = RuntimeMode.CONTROLLER == info.getRuntimeMode();
        this.monitor = monitor;
    }

    public void onDeploy(QName deployable, String plan) {
        if (this.enabled) {
            this.monitor.deploy(deployable);
        }
    }

    public void onDeployCompleted(QName deployable, String plan) {
        if (this.enabled) {
            this.monitor.deploymentCompleted(deployable);
        }
    }

    public void onUndeploy(QName undeployed) {
        if (this.enabled) {
            this.monitor.undeploy(undeployed);
        }
    }

    public void onUndeployCompleted(QName undeployed) {
        if (this.enabled) {
            this.monitor.undeployCompleted(undeployed);
        }
    }

    public void onDeploy(URI contribution) {
    }

    public void onDeployCompleted(URI contribution) {
    }

    public void onUnDeploy(URI contribution) {
    }

    public void onUnDeployCompleted(URI contribution) {
    }
}

