/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3Event;
import org.fabric3.spi.event.Fabric3EventListener;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class EventServiceImpl
implements EventService {
    private Map<Class<Fabric3Event>, List<Fabric3EventListener<Fabric3Event>>> cache = new ConcurrentHashMap<Class<Fabric3Event>, List<Fabric3EventListener<Fabric3Event>>>();

    public void publish(Fabric3Event event) {
        List<Fabric3EventListener<Fabric3Event>> listeners = this.cache.get(event.getClass());
        if (listeners == null) {
            return;
        }
        for (Fabric3EventListener<Fabric3Event> listener : listeners) {
            listener.onEvent(event);
        }
    }

    public <T extends Fabric3Event> void subscribe(Class<T> type, Fabric3EventListener<T> listener) {
        List<Fabric3EventListener<Fabric3Event>> listeners = this.cache.get(type);
        if (listeners == null) {
            listeners = new ArrayList<Fabric3EventListener<Fabric3Event>>();
            this.cache.put(type, listeners);
        }
        listeners.add(listener);
    }

    public <T extends Fabric3Event> void unsubscribe(Class<T> type, Fabric3EventListener<T> listener) {
        List<Fabric3EventListener<Fabric3Event>> listeners = this.cache.get(type);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }
}

